/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.build;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceCodeUpdater
extends SimpleFileVisitor<Path> {
    private static final Logger log = LoggerFactory.getLogger(SourceCodeUpdater.class);
    final Path expected;
    final Path other;
    final OnDiff onDiff;
    private boolean diffPresent = false;
    private boolean error = false;

    public SourceCodeUpdater(Path expected, Path other, OnDiff operation) {
        this.expected = expected.toAbsolutePath();
        this.other = other;
        this.onDiff = operation;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
        Path relative = this.expected.relativize(file);
        if (this.other.resolve(relative).toFile().exists()) {
            String checkSumStatus = null;
            try (FileInputStream fisFirst = new FileInputStream(file.toFile());
                 FileInputStream fisSecond = new FileInputStream(this.other.resolve(relative).toFile());){
                if (DigestUtils.md5Hex((InputStream)fisFirst).equals(DigestUtils.md5Hex((InputStream)fisSecond))) {
                    checkSumStatus = "identical";
                } else {
                    this.diffPresent = true;
                    checkSumStatus = "different";
                    log.info("Found different check sum for file: {}, merging changes", (Object)relative);
                    Files.copy(file, this.other.resolve(relative), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
            catch (IOException e) {
                log.error("IO happend, new build will be created", (Throwable)e);
                this.error = true;
                return FileVisitResult.TERMINATE;
            }
            log.debug("Other has file: {}, md5 check sum is {}", (Object)relative, (Object)checkSumStatus);
        } else {
            this.diffPresent = true;
            try {
                if (this.onDiff == OnDiff.COPY) {
                    log.info("GitRepo does not contain file: {}, adding", (Object)relative);
                    Files.copy(file, this.other.resolve(relative), new CopyOption[0]);
                } else {
                    log.info("GitRepo contains file that is no longer present locally: {}, deleting", (Object)relative);
                    Files.delete(file);
                }
            }
            catch (IOException e) {
                log.error("IO happend, new build will be created", (Throwable)e);
                this.error = true;
                return FileVisitResult.TERMINATE;
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attr) {
        if (dir.getFileName().toString().equals(".git")) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (this.onDiff == OnDiff.COPY) {
            Path relative = this.expected.relativize(dir);
            if (this.other.resolve(relative).toFile().exists()) {
                log.debug("Other has dir: {}", (Object)relative);
            } else {
                this.diffPresent = true;
                try {
                    log.info("GitRepo does not contain dir: {}, adding", (Object)relative);
                    Files.copy(dir, this.other.resolve(relative), new CopyOption[0]);
                }
                catch (IOException e) {
                    log.error("IO happend, new build will be created", (Object)e.getMessage());
                    this.error = true;
                    return FileVisitResult.TERMINATE;
                }
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (this.onDiff == OnDiff.DELETE) {
            Path relative = this.expected.relativize(dir);
            if (this.other.resolve(relative).toFile().exists()) {
                log.debug("Other has dir: {}", (Object)relative);
            } else {
                this.diffPresent = true;
                try {
                    log.info("GitRepo contains dir that is no longer present locally: {}, deleting", (Object)relative);
                    Files.delete(dir);
                }
                catch (IOException e) {
                    log.error("IO happend, new build will be created", (Object)e.getMessage());
                    this.error = true;
                    return FileVisitResult.TERMINATE;
                }
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        log.error(exc.getMessage());
        return FileVisitResult.CONTINUE;
    }

    public boolean isDiffPresent() {
        return this.diffPresent;
    }

    public boolean isError() {
        return this.error;
    }

    public static enum OnDiff {
        COPY,
        DELETE;

    }
}

