/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.jacoco;

import cz.xtf.TestConfiguration;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Base64;
import org.jboss.dmr.ModelNode;

public class JacocoUtil {
    private static final String podJacocoJavaOptions = "-javaagent:/etc/secrets/jacoco/jacocoagent.jar=destfile=/tmp/jacoco.exec,jmx=true,dumponexit=false";

    public static String generateJacocoConfiguration(String name) {
        Paths.get("tmp", "jacoco").toFile().mkdirs();
        try {
            Path tmp = Files.createTempFile(Paths.get("tmp", "jacoco"), name + ".", ".jacoco.exec", new FileAttribute[0]);
            return "-javaagent:" + TestConfiguration.jacocoPath() + "/lib/jacocoagent.jar=destfile=" + tmp.toAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Secret createOrGetJacocoSecret() {
        OpenshiftUtil openshift = OpenshiftUtil.getInstance();
        Secret jacocoSecret = openshift.withDefaultUser(c -> ((SecretList)c.secrets().list()).getItems().stream().filter(s -> "jacoco".equals(s.getMetadata().getName())).findAny()).orElseGet(() -> {
            SecretBuilder sb = new SecretBuilder();
            ((SecretFluent.MetadataNested)sb.withNewMetadata().withName("jacoco")).endMetadata();
            try {
                sb.addToData("jacocoagent.jar", Base64.encodeBase64String((byte[])Files.readAllBytes(Paths.get(TestConfiguration.jacocoPath(), "lib", "jacocoagent.jar"))));
                Secret ret = sb.build();
                openshift.createSecret(ret);
                return ret;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return jacocoSecret;
    }

    public static void addJacocoToDeploymentConfig(DeploymentConfigBuilder builder, String javaOptionsEnv) {
        Secret jacocoSecret = JacocoUtil.createOrGetJacocoSecret();
        builder.podTemplate().addLabel("jacoco", "true");
        builder.podTemplate().container().addVolumeMount("jacoco", "/etc/secrets/jacoco", true);
        builder.podTemplate().addSecretVolume("jacoco", jacocoSecret.getMetadata().getName());
        builder.podTemplate().container().envVar(javaOptionsEnv, podJacocoJavaOptions);
    }

    public static void addJacocoToDeploymentConfig(ModelNode deploymentConfig, String javaOptionsEnv) {
        Secret jacocoSecret = JacocoUtil.createOrGetJacocoSecret();
        deploymentConfig.get("spec").get("template").get("metadata").get("labels").get("jacoco").set("true");
        ModelNode volume = deploymentConfig.get("spec").get("template").get("spec").get("volumes").addEmptyObject();
        volume.get("name").set("jacoco");
        volume.get("secret").get("secretName").set(jacocoSecret.getMetadata().getName());
        Consumer<ModelNode> addJacocoToContainer = container -> {
            ModelNode env = container.get("env");
            ModelNode envItem = env.addEmptyObject();
            envItem.get("name").set(javaOptionsEnv);
            envItem.get("value").set(podJacocoJavaOptions);
            ModelNode volumeMount = container.get("volumeMounts").addEmptyObject();
            volumeMount.get("name").set("jacoco");
            volumeMount.get("readOnly").set(true);
            volumeMount.get("mountPath").set("/etc/secrets/jacoco");
        };
        List containers = deploymentConfig.get("spec").get("template").get("spec").get("containers").asList();
        if (containers.size() == 0) {
            ModelNode container2 = deploymentConfig.get("spec").get("template").get("spec").get("containers").addEmptyObject();
            addJacocoToContainer.accept(container2);
        } else {
            for (ModelNode container3 : containers) {
                addJacocoToContainer.accept(container3);
            }
        }
    }
}

