/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.manipulation;

import cz.xtf.openshift.OpenshiftUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogCleaner {
    private static final Logger log = LoggerFactory.getLogger(LogCleaner.class);

    private LogCleaner() {
    }

    public static void cleanAllLogDirectories() {
        LogCleaner.cleanPodLogDirectories();
        LogCleaner.cleanBuildLogDirectories();
    }

    public static void cleanPodLogDirectories() {
        File podLogsDir = OpenshiftUtil.getPodLogsDir().toFile();
        log.info("action=clean-pod-logs status=START dir={}", (Object)podLogsDir.getAbsolutePath());
        try {
            if (podLogsDir.exists()) {
                FileUtils.deleteDirectory((File)podLogsDir);
            }
            podLogsDir.mkdirs();
            log.info("action=clean-pod-logs status=FINISH dir={}", (Object)podLogsDir.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("action=clean-pod-logs status=ERROR dir={}", (Object)podLogsDir.getAbsolutePath(), (Object)e);
        }
    }

    public static void cleanBuildLogDirectories() {
        File buildLogsDir = OpenshiftUtil.getBuildLogsDir().toFile();
        log.info("action=clean-build-logs status=START dir={}", (Object)buildLogsDir.getAbsolutePath());
        try {
            if (buildLogsDir.exists()) {
                FileUtils.deleteDirectory((File)buildLogsDir);
            }
            buildLogsDir.mkdirs();
            log.info("action=clean-build-logs status=FINISH dir={}", (Object)buildLogsDir.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("action=clean-build-logs status=ERROR dir={}", (Object)buildLogsDir.getAbsolutePath(), (Object)e);
        }
    }
}

