/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.manipulation;

import cz.xtf.TestConfiguration;
import cz.xtf.openshift.OpenShiftContext;
import cz.xtf.openshift.OpenshiftUtil;
import java.io.FileWriter;
import java.io.IOException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectHandler {
    private static final Logger log = LoggerFactory.getLogger(ProjectHandler.class);
    private static final String TEMP_NAMESPACE_IDENTIFIER = "-automated";
    private static OpenshiftUtil openshift = OpenshiftUtil.getInstance();
    private String project;
    private String namespace;
    private boolean temporaryNamespace;
    private OpenShiftContext originalContext;
    private boolean used;

    public ProjectHandler(String project) {
        this(project, TestConfiguration.masterNamespace());
    }

    public ProjectHandler(@NonNull String project, String namespace) {
        if (project == null) {
            throw new NullPointerException("project");
        }
        this.project = project;
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            this.namespace = namespace;
        } else {
            this.namespace = project + TEMP_NAMESPACE_IDENTIFIER;
            this.temporaryNamespace = true;
        }
    }

    private static void createProject(String project, boolean recreate) {
        log.info("action=create-project status=START project={} recreate={}", (Object)project, (Object)recreate);
        OpenShiftContext originalContext = openshift.getContext();
        openshift.setOpenShiftContext(OpenShiftContext.getContext("cluster-admin"));
        openshift.createProject(project, recreate);
        openshift.setOpenShiftContext(originalContext);
        log.info("action=create-project status=FINISH project={} recreate={}", (Object)project, (Object)recreate);
    }

    public void prepare() {
        if (this.used) {
            throw new IllegalStateException("Project handling was already used, create new handler!");
        }
        this.used = true;
        if (this.temporaryNamespace) {
            this.originalContext = openshift.getContext();
            log.info("action=create-temp-context status=START project={} namespace={}", (Object)this.project, (Object)this.namespace);
            OpenShiftContext.newContext(this.project, TestConfiguration.masterUsername(), TestConfiguration.masterPassword(), this.namespace);
            openshift.setOpenShiftContext(OpenShiftContext.getContext(this.project));
            log.info("action=create-temp-context status=FINISH project={} namespace={}", (Object)this.project, (Object)this.namespace);
        }
        ProjectHandler.createProject(this.namespace, this.temporaryNamespace);
    }

    public void saveEventsLog() {
        OpenshiftUtil.getProjectLogsDir().toFile().mkdirs();
        try (FileWriter writer = new FileWriter(OpenshiftUtil.getProjectLogsDir().resolve("events.log").toFile());){
            log.info("action=record-events status=START namespace={}", (Object)this.namespace);
            writer.write(OpenshiftUtil.getInstance().getEvents(this.namespace));
            log.info("action=record-events status=FINISH namespace={}", (Object)this.namespace);
        }
        catch (IOException e) {
            log.info("action=record-events status=ERROR namespace={}", (Object)this.namespace, (Object)e);
        }
    }

    public void cleanup() {
        if (this.temporaryNamespace) {
            this.restoreContext();
            this.deleteNamespace();
        }
        this.used = true;
    }

    private void restoreContext() {
        OpenshiftUtil.getInstance().setOpenShiftContext(this.originalContext);
    }

    private void deleteNamespace() {
        log.info("action=remove-temp-namespace status=START namespace={}", (Object)this.namespace);
        OpenshiftUtil.getInstance().deleteProject(this.namespace);
        log.info("action=remove-temp-namespace status=FINISH namespace={}", (Object)this.namespace);
    }

    public String getProject() {
        return this.project;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

