/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.manipulation;

import cz.xtf.http.HttpClient;
import cz.xtf.openshift.OpenshiftUtil;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;

public final class TemplateImporter {
    private TemplateImporter() {
    }

    public static Template importTemplate(String source) {
        return OpenshiftUtil.getInstance().withDefaultUser(client -> {
            try (ByteArrayInputStream is = new ByteArrayInputStream(HttpClient.get(source).response().getBytes(StandardCharsets.UTF_8));){
                TemplateResource template = (TemplateResource)client.templates().load((InputStream)is);
                ((TemplateResource)client.templates().withName(((Template)template.get()).getMetadata().getName())).delete();
                Template template2 = (Template)template.create((Object[])new Template[0]);
                return template2;
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Malformed template url", ex);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to import template", ex);
            }
        });
    }
}

