/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift;

import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.wait.WaitUtil;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftApplication {
    public static final long BUILD_TIMEOUT = 10L;
    public static final TimeUnit BUILD_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenshiftApplication.class);
    private final OpenshiftUtil openshift;
    private final String name;
    private List<Secret> secrets = new LinkedList<Secret>();
    private List<ServiceAccount> serviceAccounts = new LinkedList<ServiceAccount>();
    private List<ImageStream> imageStreams = new LinkedList<ImageStream>();
    private List<BuildConfig> buildConfigs = new LinkedList<BuildConfig>();
    private List<PersistentVolumeClaim> persistentVolumeClaims = new LinkedList<PersistentVolumeClaim>();
    private List<DeploymentConfig> deploymentConfigs = new LinkedList<DeploymentConfig>();
    private List<Service> services = new LinkedList<Service>();
    private List<Endpoints> endpoints = new LinkedList<Endpoints>();
    private List<Route> routes = new LinkedList<Route>();
    private List<ConfigMap> configMaps = new LinkedList<ConfigMap>();
    private List<HorizontalPodAutoscaler> autoScalers = new LinkedList<HorizontalPodAutoscaler>();
    private BuildConfig buildConfig;
    private DeploymentConfig mainDeployment;
    private Service mainService;
    private Route mainRoute;
    private Optional<String> serviceAccountName = Optional.empty();

    public OpenshiftApplication(ApplicationBuilder builder) {
        this.openshift = OpenshiftUtil.getInstance();
        this.name = builder.getName();
        this.secrets.addAll(builder.getSecrets());
        this.imageStreams.addAll(builder.buildImageStreams());
        this.buildConfigs.addAll(builder.buildBuildConfigs());
        this.buildConfig = this.findMainResource(this.buildConfigs, this.name + "-build");
        this.deploymentConfigs.addAll(builder.buildDeploymentConfigs());
        this.mainDeployment = this.findMainResource(this.deploymentConfigs, this.name);
        this.endpoints.addAll(builder.buildEndpoints());
        this.services.addAll(builder.buildServices());
        this.mainService = this.findMainResource(this.services, this.name + "-service");
        this.routes.addAll(builder.buildRoutes());
        this.mainRoute = this.findMainResourceWithPrefix(this.routes, this.name + "-route");
        this.configMaps.addAll(builder.buildConfigMaps());
        this.autoScalers.addAll(builder.buildAutoScalers());
    }

    public OpenshiftApplication createServiceAccountFromSecrets(String accountName) {
        this.serviceAccountName = Optional.ofNullable(accountName);
        return this;
    }

    private void createServiceAccount() {
        this.serviceAccountName.ifPresent(accountName -> {
            LOGGER.debug("Creating service account {}", accountName);
            this.openshift.createServiceAccount(((ServiceAccountBuilder)((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName(accountName)).endMetadata()).withSecrets(this.secrets.stream().map(secret -> ((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind(secret.getKind())).withName(secret.getMetadata().getName())).build()).collect(Collectors.toList()))).build());
        });
    }

    public void deploy() {
        this.deploy(10L, BUILD_TIMEOUT_UNIT);
    }

    public void deploy(long timeout, TimeUnit timeUnit) {
        this.deployWithoutBuild();
        LOGGER.debug("Building application {} through manual build and waiting for results", (Object)this.name);
        this.openshift.waitForBuildCompletion(this.triggerManualBuild(), timeout, timeUnit, true);
    }

    public void deployWithoutBuild() {
        LOGGER.debug("Deploying application {}", (Object)this.name);
        this.secrets = this.secrets.stream().map(this.openshift::createSecret).collect(Collectors.toList());
        this.serviceAccounts = this.serviceAccounts.stream().map(this.openshift::createServiceAccount).collect(Collectors.toList());
        this.imageStreams = this.imageStreams.stream().map(this.openshift::createImageStream).collect(Collectors.toList());
        this.buildConfigs = this.buildConfigs.stream().map(this.openshift::createBuildConfig).collect(Collectors.toList());
        this.persistentVolumeClaims = this.persistentVolumeClaims.stream().map(this.openshift::createPersistentVolumeClaim).collect(Collectors.toList());
        this.services = this.services.stream().map(this.openshift::createService).collect(Collectors.toList());
        List syncDeployments = this.deploymentConfigs.stream().filter(x -> x.getMetadata().getLabels().containsKey("synchronousId")).sorted((dc1, dc2) -> {
            int labelDc1 = Integer.parseInt((String)dc1.getMetadata().getLabels().get("synchronousId"));
            int labelDc2 = Integer.parseInt((String)dc2.getMetadata().getLabels().get("synchronousId"));
            return labelDc1 - labelDc2;
        }).map(x -> {
            String deploymentId = (String)x.getMetadata().getLabels().get("synchronousId");
            DeploymentConfig dc = this.openshift.createDeploymentConfig((DeploymentConfig)x);
            try {
                LOGGER.info("Waiting for a startup of pod with syncId '{}'", (Object)deploymentId);
                WaitUtil.waitFor(WaitUtil.isAPodReady("synchronousId", deploymentId));
                TimeUnit.SECONDS.sleep(20L);
            }
            catch (Exception e) {
                throw new IllegalStateException("Timeout while waiting for dpeloyment of " + dc.getMetadata().getName());
            }
            return dc;
        }).collect(Collectors.toList());
        this.deploymentConfigs = this.deploymentConfigs.stream().filter(x -> !x.getMetadata().getLabels().containsKey("synchronousId")).map(this.openshift::createDeploymentConfig).collect(Collectors.toList());
        this.deploymentConfigs.addAll(syncDeployments);
        this.endpoints = this.endpoints.stream().map(this.openshift::createEndpoint).collect(Collectors.toList());
        this.routes = this.routes.stream().map(this.openshift::createRoute).collect(Collectors.toList());
        this.configMaps = this.configMaps.stream().map(this.openshift::createConfigMap).collect(Collectors.toList());
        this.autoScalers = this.autoScalers.stream().map(this.openshift::createHorizontalPodAutoscaler).collect(Collectors.toList());
        if (this.buildConfig != null) {
            this.buildConfig = this.findMainResource(this.buildConfigs, this.buildConfig.getMetadata().getName());
        }
        if (this.mainDeployment != null) {
            this.mainDeployment = this.findMainResource(this.deploymentConfigs, this.mainDeployment.getMetadata().getName());
        }
        if (this.mainService != null) {
            this.mainService = this.findMainResource(this.services, this.mainService.getMetadata().getName());
        }
        if (this.mainRoute != null) {
            this.mainRoute = this.findMainResource(this.routes, this.mainRoute.getMetadata().getName());
        }
        this.createServiceAccount();
    }

    public Build triggerManualBuild() {
        if (this.buildConfig == null) {
            throw new IllegalStateException("Default build config was not found in application " + this.name);
        }
        return this.openshift.startBuild(this.buildConfig);
    }

    public void updateEnviromentVariable(String variableName, String variableValue, boolean overwrite) {
        if (this.mainDeployment == null) {
            throw new IllegalStateException("Main Deployment Config was not found in application " + this.name);
        }
        this.openshift.updateEnviromentVariable(this.mainDeployment, variableName, variableValue, overwrite);
    }

    public String getHostName() {
        if (this.mainRoute == null) {
            throw new IllegalStateException("Default route was not found in application " + this.name);
        }
        return this.mainRoute.getSpec().getHost();
    }

    private <T extends HasMetadata> T findMainResource(Collection<T> resources, String defaultName) {
        if (resources.size() == 1) {
            return (T)((HasMetadata)resources.iterator().next());
        }
        Optional<HasMetadata> match = resources.stream().filter(resource -> defaultName.equals(resource.getMetadata().getName())).findFirst();
        if (match.isPresent()) {
            return (T)match.get();
        }
        LOGGER.debug("No default resource found '{}'", (Object)defaultName);
        return null;
    }

    private <T extends HasMetadata> T findMainResourceWithPrefix(Collection<T> resources, String defaultName) {
        if (resources.size() == 1) {
            return (T)((HasMetadata)resources.iterator().next());
        }
        Optional<HasMetadata> match = resources.stream().filter(resource -> resource.getMetadata().getName().startsWith(defaultName)).findFirst();
        if (match.isPresent()) {
            return (T)match.get();
        }
        LOGGER.debug("No default resource found '{}'", (Object)defaultName);
        return null;
    }
}

