/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.db;

import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import cz.xtf.openshift.db.AbstractDatabase;
import cz.xtf.openshift.imagestream.ImageRegistry;
import java.util.Map;

public class MongoDB
extends AbstractDatabase {
    public MongoDB() {
        super("MONGODB", "/var/lib/mongodb/data");
    }

    public MongoDB(String username, String password, String dbName) {
        super(username, password, dbName, "MONGODB", "/var/lib/mongodb/data");
    }

    @Override
    public String getImageName() {
        return ImageRegistry.get().mongodb();
    }

    @Override
    public int getPort() {
        return 27017;
    }

    @Override
    public void configureApplicationDeployment(DeploymentConfigBuilder dcBuilder) {
        dcBuilder.podTemplate().container().envVars(this.getImageVariables());
    }

    @Override
    public Map<String, String> getImageVariables() {
        Map<String, String> vars = super.getImageVariables();
        vars.put(this.getSymbolicName() + "_ADMIN_PASSWORD", this.getPassword());
        return vars;
    }
}

