/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.messaging;

import cz.xtf.docker.DockerContainer;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import cz.xtf.openshift.builder.pod.PersistentVolumeClaim;
import cz.xtf.openshift.imagestream.ImageRegistry;
import cz.xtf.openshift.messaging.MessageBroker;
import cz.xtf.openshift.storage.DefaultStatefulAuxiliary;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JBossAMQ
extends DefaultStatefulAuxiliary
implements MessageBroker {
    static final String SYMBOLIC_NAME = "jbamq";
    private static final String USERNAME = "mqUser";
    private static final String PASSWORD = "mqPassword";
    private static final String ADMIN_USERNAME = "adminUser";
    private static final String ADMIN_PASSWORD = "adminPassword";
    private static final int OPENWIRE_PORT = 61616;
    private final List<String> queues = new ArrayList<String>();
    private final List<String> topics = new ArrayList<String>();
    private String jndiName;

    public JBossAMQ() {
        super(SYMBOLIC_NAME, "/opt/amq/data");
    }

    public JBossAMQ(PersistentVolumeClaim pvc) {
        super(SYMBOLIC_NAME, "/opt/amq/data", pvc);
    }

    public Map<String, String> getImageVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("AMQ_USER", USERNAME);
        vars.put("AMQ_PASSWORD", PASSWORD);
        vars.put("AMQ_ADMIN_USERNAME", ADMIN_USERNAME);
        vars.put("AMQ_ADMIN_PASSWORD", ADMIN_PASSWORD);
        vars.put("AMQ_PROTOCOLS", "tcp");
        vars.put("AMQ_QUEUES", this.getQueueList());
        vars.put("AMQ_TOPIC", this.getTopicList());
        return vars;
    }

    @Override
    public DeploymentConfigBuilder configureDeployment(ApplicationBuilder appBuilder, boolean synchronous) {
        DeploymentConfigBuilder builder = appBuilder.deploymentConfig(SYMBOLIC_NAME, SYMBOLIC_NAME, false);
        builder.onConfigurationChange().podTemplate().container().fromImage(ImageRegistry.get().amq()).envVars(this.getImageVariables()).port(61616, "tcp").port(8778, "jolokia");
        if (synchronous) {
            builder.onConfigurationChange();
            builder.synchronousDeployment();
        }
        if (this.isStateful) {
            this.storagePartition.configureApplicationDeployment(builder);
        }
        if (this.persistentVolClaim != null) {
            builder.podTemplate().addPersistenVolumeClaim(this.persistentVolClaim.getName(), this.persistentVolClaim.getClaimName());
            builder.podTemplate().container().addVolumeMount(this.persistentVolClaim.getName(), this.dataDir, false);
        }
        appBuilder.service("jbamq-amq-tcp").setPort(61616).setContainerPort(61616).addContainerSelector("name", SYMBOLIC_NAME);
        return builder;
    }

    @Override
    public void configureApplicationDeployment(DeploymentConfigBuilder dcBuilder) {
        String mqServiceMapping = dcBuilder.podTemplate().container().getEnvVars().getOrDefault("MQ_SERVICE_PREFIX_MAPPING", "");
        if (mqServiceMapping.length() != 0) {
            mqServiceMapping = mqServiceMapping.concat(",");
        }
        dcBuilder.podTemplate().container().envVar("MQ_SERVICE_PREFIX_MAPPING", mqServiceMapping.concat(String.format("%s-amq=%S", SYMBOLIC_NAME, SYMBOLIC_NAME))).envVar(this.getEnvVarName("USERNAME"), USERNAME).envVar(this.getEnvVarName("PASSWORD"), PASSWORD).envVar(this.getEnvVarName("QUEUES"), this.getQueueList()).envVar(this.getEnvVarName("TOPICS"), this.getTopicList()).envVar(this.getEnvVarName("PROTOCOL"), "tcp");
        if (StringUtils.isNotBlank((CharSequence)this.jndiName)) {
            dcBuilder.podTemplate().container().envVar(this.getEnvVarName("JNDI"), this.jndiName);
        }
    }

    private String getTopicList() {
        return this.topics.stream().collect(Collectors.joining(","));
    }

    private String getQueueList() {
        return this.queues.stream().collect(Collectors.joining(","));
    }

    @Override
    public Pod getPod() {
        return OpenshiftUtil.getInstance().findNamedPod(SYMBOLIC_NAME);
    }

    @Override
    public DockerContainer getContainer() {
        return DockerContainer.createForPod(this.getPod(), SYMBOLIC_NAME);
    }

    @Override
    public JBossAMQ withQueues(String ... queues) {
        Collections.addAll(this.queues, queues);
        return this;
    }

    @Override
    public JBossAMQ withTopics(String ... topics) {
        Collections.addAll(this.topics, topics);
        return this;
    }

    public JBossAMQ withJndiName(String jndiName) {
        this.jndiName = jndiName;
        return this;
    }

    public String getEnvVarName(String name) {
        return String.format("%S_%S", SYMBOLIC_NAME, name);
    }
}

