/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.git;

import cz.xtf.TestProjectProfileResolver;
import cz.xtf.io.IOUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PomModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomModifier.class);
    private static DocumentBuilderFactory builderFactory;
    private static DocumentBuilder builder;
    private static TransformerFactory transformerFactory;
    private static Transformer transformer;
    private Document parsedDocument;
    private final Path projectPomFile;
    private final Path projectDirectory;
    private final Path gitDirectory;
    private Path parentPomFile;
    private Path parentDirectory;

    public PomModifier(Path projectDirectory, Path gitDirectory) {
        if (builderFactory == null) {
            builderFactory = DocumentBuilderFactory.newInstance();
            transformerFactory = TransformerFactory.newInstance();
            try {
                builder = builderFactory.newDocumentBuilder();
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            catch (ParserConfigurationException | TransformerConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
        this.projectPomFile = gitDirectory.resolve("pom.xml");
        this.projectDirectory = projectDirectory;
        this.gitDirectory = gitDirectory;
    }

    private Element childElement(Element parentNode, String elementName) {
        List<Element> children = this.childElements(parentNode, elementName);
        return children.size() > 0 ? children.get(0) : null;
    }

    private Element createChildElement(Element parentNode, String elementName) {
        List<Element> children = this.childElements(parentNode, elementName);
        if (children.size() > 0) {
            return children.get(0);
        }
        Element element = this.parsedDocument.createElement(elementName);
        parentNode.appendChild(element);
        return element;
    }

    private List<Element> childElements(Element parentNode, String elementName) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList nodes = parentNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            if (nodes.item(i).getNodeType() != 1 || !elementName.equals((element = (Element)nodes.item(i)).getTagName())) continue;
            ret.add(element);
        }
        return ret;
    }

    private String getElementText(Node element) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 3) continue;
            return nodes.item(i).getTextContent();
        }
        return null;
    }

    private void setElementText(Node element, String text) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 3) continue;
            nodes.item(i).setTextContent(text);
            return;
        }
        element.appendChild(this.parsedDocument.createTextNode(text));
    }

    private boolean modifyProjectPOM() {
        LOGGER.info("Parsing POM {}", (Object)this.projectPomFile);
        if (!this.projectPomFile.toFile().exists()) {
            LOGGER.debug("Non-Maven project, skipping manipulation");
            return false;
        }
        try {
            this.parseDocument(this.projectPomFile);
            Element root = this.parsedDocument.getDocumentElement();
            Element parent = this.childElement(root, "parent");
            if (parent == null) {
                LOGGER.debug("No parent found, skipping manipulation");
                return false;
            }
            Element relativePath = this.childElement(parent, "relativePath");
            if (relativePath == null) {
                LOGGER.error("Relative path required");
                throw new IllegalStateException("Relative path required in parent");
            }
            String parentLocation = this.getElementText(relativePath);
            this.parentDirectory = this.projectDirectory.resolve(parentLocation).normalize().toAbsolutePath();
            if (!this.parentDirectory.toFile().exists()) {
                throw new IllegalArgumentException("Parent directory does not exist " + this.parentDirectory);
            }
            relativePath.setTextContent(this.parentDirectory.toFile().getName());
            this.writePOMFile(this.projectPomFile, root);
        }
        catch (IOException | TransformerException | SAXException e) {
            throw new IllegalStateException(e);
        }
        return true;
    }

    private void modifyParentPOM(String activatedProfile) {
        LOGGER.info("Parsing POM {}", (Object)this.parentPomFile);
        try {
            this.parseDocument(this.parentPomFile);
            Element root = this.parsedDocument.getDocumentElement();
            Element profiles = this.childElement(root, "profiles");
            if (profiles == null) {
                LOGGER.debug("No profiles found, skipping manipulation");
                return;
            }
            this.childElements(profiles, "profile").forEach(profile -> {
                String id = this.getElementText(this.childElement((Element)profile, "id"));
                if (activatedProfile.equals(id)) {
                    this.activateProfile((Element)profile);
                } else {
                    this.deactivateProfile((Element)profile);
                }
            });
            this.writePOMFile(this.parentPomFile, root);
        }
        catch (IOException | TransformerException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private Document parseDocument(Path pomFile) throws SAXException, IOException {
        this.parsedDocument = builder.parse(pomFile.toFile());
        return this.parsedDocument;
    }

    private void writePOMFile(Path pomFile, Element root) throws FileNotFoundException, TransformerException, IOException {
        FileOutputStream fos = new FileOutputStream(pomFile.toFile());
        transformer.transform(new DOMSource(root), new StreamResult(fos));
        fos.close();
    }

    private void activateProfile(Element profile) {
        this.setElementText(this.createChildElement(this.createChildElement(profile, "activation"), "activeByDefault"), "true");
    }

    private void deactivateProfile(Element profile) {
        this.setElementText(this.createChildElement(this.createChildElement(profile, "activation"), "activeByDefault"), "false");
    }

    private void copyParentDirectory() {
        Path parentDestDir = this.gitDirectory.resolve(this.parentDirectory.getFileName());
        parentDestDir.toFile().mkdir();
        try {
            IOUtils.copy(this.parentDirectory, parentDestDir);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.parentPomFile = parentDestDir.resolve("pom.xml");
    }

    private boolean isPomModifierSupported() {
        return StreamSupport.stream(this.projectDirectory.spliterator(), false).anyMatch(x -> x.getFileName().endsWith("test-eap") || x.getFileName().endsWith("test-amq") || x.getFileName().endsWith("test-jdv") || x.getFileName().endsWith("test-ews") || x.getFileName().endsWith("test-fuse") || x.getFileName().endsWith("test-msa") || x.getFileName().endsWith("test-jdg") || x.getFileName().endsWith("test-sso") || x.getFileName().endsWith("test-common"));
    }

    private boolean isParentModifierSupported() {
        return StreamSupport.stream(this.projectDirectory.spliterator(), false).anyMatch(x -> x.getFileName().endsWith("test-eap") || x.getFileName().endsWith("test-amq") || x.getFileName().endsWith("test-jdv") || x.getFileName().endsWith("test-ews") || x.getFileName().endsWith("test-msa") || x.getFileName().endsWith("test-jdg") || x.getFileName().endsWith("test-sso") || x.getFileName().endsWith("test-common"));
    }

    public void modify() {
        if (!this.isPomModifierSupported() || !this.modifyProjectPOM()) {
            return;
        }
        this.copyParentDirectory();
        if (this.isParentModifierSupported()) {
            this.modifyParentPOM(TestProjectProfileResolver.get().getProfileName(this.parentDirectory.toFile().getName()));
        }
    }
}

