/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompositeFilterContainer<T> {
    private static final Logger log = LoggerFactory.getLogger(CompositeFilterContainer.class);
    protected final Set<T> filters = new HashSet<T>();

    public void addFilters(Collection<T> filters) {
        filters.forEach(this::addFilter);
    }

    public void addFilter(T filter) {
        if (filter == null) {
            return;
        }
        if (filter instanceof CompositeFilterContainer) {
            this.addFilters(((CompositeFilterContainer)filter).getFilters());
        } else {
            this.filters.add(filter);
        }
    }

    public Set<T> getFilters() {
        return this.filters;
    }
}

