/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.maven;

import com.google.common.collect.ImmutableMap;
import cz.xtf.TestConfiguration;
import cz.xtf.io.IOUtils;
import cz.xtf.maven.MavenUtil;
import cz.xtf.openshift.KubernetesVersion;
import cz.xtf.openshift.OpenShiftBinaryClient;
import cz.xtf.openshift.OpenshiftUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.it.VerificationException;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fabric8MavenWrapper {
    private static final Logger log = LoggerFactory.getLogger(Fabric8MavenWrapper.class);
    public static final String MASTER_URL = "masterUrl";
    public static final String MASTER_USER_NAME = "masterUserName";
    public static final String MASTER_PASSWORD = "masterPassword";
    public static final String MASTER_TOKEN = "masterToken";
    public static final String NAMESPACE = "namespace";
    private static final Path DEFAULT_SETTINGS = FileSystems.getDefault().getPath("../utilities/src/main/resources/settings.xml", new String[0]).toAbsolutePath();
    static final String MANIFEST_PATH = "target/classes/META-INF/fabric8/openshift.json";
    private static final AtomicReference<Object> currentNameSpace = new AtomicReference();
    private static final Map<String, String> FABRIC8_LOGIN_PROPERTIES = new ImmutableMap.Builder().put((Object)"kubernetes.auth.basic.username", (Object)TestConfiguration.masterUsername()).put((Object)"kubernetes.auth.basic.password", (Object)TestConfiguration.masterPassword()).put((Object)"kubernetes.master", (Object)Fabric8MavenWrapper.resolveIpAddressUrl(TestConfiguration.masterUrl(), false)).put((Object)"kubernetes.trust.certificates", (Object)"true").put((Object)"kubernetes.auth.tryKubeConfig", (Object)"false").put((Object)"kubernetes.auth.tryServiceAccount", (Object)"false").build();
    protected MavenUtil maven;
    private Path projectPath;
    private Map<String, String> overrideOptions;

    public Fabric8MavenWrapper(Path projectPath) throws VerificationException {
        this(projectPath, DEFAULT_SETTINGS);
    }

    public Fabric8MavenWrapper(Path projectPath, Path settingsPath) throws VerificationException {
        this.maven = MavenUtil.forProject(projectPath, settingsPath).forkJvm();
        this.maven.addCliOptions("-Dfabric8.imagePullPolicy=Always");
        this.maven.addCliOptions("-Dkubeconfig=" + IOUtils.TMP_DIRECTORY.resolve("oc").resolve("oc.config"));
        this.maven.disableAutoclean();
        this.overrideOptions = new HashMap<String, String>();
        this.projectPath = projectPath;
    }

    public Fabric8MavenWrapper withImage(String image) {
        this.maven.addCliOptions("-Dfabric8.generator.from=" + image);
        this.maven.addCliOptions("-Dfabric8.generator.fromMode=docker");
        return this;
    }

    public Fabric8MavenWrapper withRoute() {
        this.maven.addCliOptions("-Dfabric8.deploy.createExternalUrls=true");
        return this;
    }

    public Fabric8MavenWrapper inCurrentNamespace() {
        return this.inNamespace(Fabric8MavenWrapper.getCurrentNameSpace());
    }

    public Fabric8MavenWrapper inNamespace(String namespace) {
        this.maven.addCliOptions("-Dfabric8.namespace=" + namespace);
        return this;
    }

    public Fabric8MavenWrapper withRollingUpgrades(boolean rollingUpgrades) {
        this.maven.addCliOptions("-Dfabric8.rolling=" + rollingUpgrades);
        return this;
    }

    public Fabric8MavenWrapper withProfile(String profile) {
        this.maven.addCliOptions("-P" + profile);
        return this;
    }

    public Fabric8MavenWrapper withManifestPath(String manifestPath) {
        this.maven.addCliOptions("-Dfabric8.openshiftManifest=" + manifestPath);
        return this;
    }

    public Fabric8MavenWrapper withCliOptions(String ... options) {
        this.maven.addCliOptions(options);
        return this;
    }

    public Fabric8MavenWrapper withOverrideOptions(Map<String, String> values) {
        this.overrideOptions = values;
        return this;
    }

    public Fabric8MavenWrapper withCliProperty(String property, String value) {
        this.withCliOptions("-D" + property + "=" + value);
        return this;
    }

    public Fabric8MavenWrapper withExplicitPropertiesForClient() {
        for (Map.Entry<String, String> entry : FABRIC8_LOGIN_PROPERTIES.entrySet()) {
            this.withCliProperty(entry.getKey(), entry.getValue());
        }
        this.inCurrentNamespace();
        return this;
    }

    public Fabric8MavenWrapper withEnvironmentVariable(String key, String value) {
        this.maven.setEnvironmentVariable(key, value);
        return this;
    }

    public Fabric8MavenWrapper withExplicitSystemVariablesForClient() {
        for (Map.Entry<String, String> entry : FABRIC8_LOGIN_PROPERTIES.entrySet()) {
            this.withEnvironmentVariable(this.formatAsEnvironment(entry.getKey()), entry.getValue());
        }
        this.inCurrentNamespace();
        return this;
    }

    private String formatAsEnvironment(String key) {
        return key.toUpperCase().replace(".", "_");
    }

    public void executeGoals(String ... goals) throws VerificationException {
        log.info("f-m-p uses oc.config from tmp dir");
        String masterUrl = this.overrideOptions.getOrDefault(MASTER_URL, TestConfiguration.masterUrl());
        String masterUserName = this.overrideOptions.getOrDefault(MASTER_USER_NAME, TestConfiguration.masterUsername());
        String masterPassword = this.overrideOptions.getOrDefault(MASTER_PASSWORD, TestConfiguration.masterPassword());
        String masterToken = this.overrideOptions.getOrDefault(MASTER_TOKEN, TestConfiguration.getMasterToken());
        String ipUrl = TestConfiguration.openshiftOnline() ? masterUrl : Fabric8MavenWrapper.resolveIpAddressUrl(masterUrl);
        try {
            OpenShiftBinaryClient.getInstance().login(ipUrl, masterUserName, masterPassword, masterToken);
        }
        catch (IOException | InterruptedException e) {
            throw new VerificationException("Unable to connect to openshift.", (Throwable)e);
        }
        String defaultNamespace = this.overrideOptions.getOrDefault(NAMESPACE, Fabric8MavenWrapper.getCurrentNameSpace());
        OpenShiftBinaryClient.getInstance().executeCommandWithReturn("oc project failed!", "project", defaultNamespace);
        this.maven.executeGoals(goals);
    }

    public static String resolveIpAddressUrl(String masterUrl) {
        return Fabric8MavenWrapper.resolveIpAddressUrl(masterUrl, true);
    }

    public static String resolveIpAddressUrl(String masterUrl, boolean useHttps) {
        try {
            return (useHttps ? "https://" : "") + InetAddress.getByName(new URL(masterUrl).getHost()).getHostAddress() + ":8443";
        }
        catch (MalformedURLException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public void executeBasicBuild() throws VerificationException {
        this.executeGoals(true, Goal.RESOURCE, Goal.BUILD, Goal.APPLY);
    }

    public void executeGoalsWithCleanInstall(Goal ... goals) throws VerificationException {
        this.executeGoals(true, goals);
    }

    public void executeGoals(Goal ... goals) throws VerificationException {
        this.executeGoals(false, goals);
    }

    private void executeGoals(boolean withCleanInstall, Goal ... goals) throws VerificationException {
        Object[] stringGoals = new String[goals.length + (withCleanInstall ? 2 : 0)];
        int index = 0;
        if (withCleanInstall) {
            stringGoals[index++] = "clean";
            stringGoals[index++] = "install";
        }
        for (Goal goal : goals) {
            stringGoals[index++] = goal.getGoal();
        }
        log.info("Starting goals: {}", (Object)Arrays.toString(stringGoals));
        this.executeGoals((String[])stringGoals);
        log.info("Ended goals: {}", (Object)Arrays.toString(stringGoals));
    }

    public static String createFabric8Url(String appName) {
        return Fabric8MavenWrapper.createFabric8Url(appName, OpenshiftUtil.getInstance().getContext().getNamespace(), TestConfiguration.routeDomain());
    }

    public static String createFabric8Url(String appName, String namespace, String domain) {
        int limit = Integer.min(KubernetesVersion.get().serviceNameLimit(), TestConfiguration.fabric8ServiceNameLimit());
        String urlName = appName.length() > limit ? appName.substring(0, limit) : appName;
        return String.format("http://%s-%s.%s", urlName, namespace, domain);
    }

    public ModelNode getDeployment() {
        File jsonFile = this.projectPath.resolve(MANIFEST_PATH).toFile();
        ModelNode template = null;
        try {
            template = ModelNode.fromJSONStream((InputStream)new FileInputStream(jsonFile));
            log.debug(template.toJSONString(false));
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to parse or access JSON: " + jsonFile.getAbsolutePath()));
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentNameSpace() {
        Object value = currentNameSpace.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = currentNameSpace;
            synchronized (atomicReference) {
                value = currentNameSpace.get();
                if (value == null) {
                    String actualValue = OpenshiftUtil.getInstance().getContext().getNamespace();
                    value = actualValue == null ? currentNameSpace : actualValue;
                    currentNameSpace.set(value);
                }
            }
        }
        return (String)(value == currentNameSpace ? null : value);
    }

    public static enum Goal {
        INSTALL("install", false),
        CLEAN("clean", false),
        PACKAGE("package", false),
        VERIFY("verify", false),
        BUILD("fabric8:build"),
        RESOURCE("fabric8:resource"),
        PUSH("fabric8:push"),
        DEPLOY("fabric8:deploy"),
        UNDEPLOY("fabric8:undeploy"),
        START("fabric8:start"),
        STOP("fabric8:stop"),
        LOG("fabric8:log"),
        DEBUG("fabric8:debug"),
        RUN("fabric8:run"),
        RESOURCE_APPLY("fabric8:resource-apply"),
        HELP("fabric8:help"),
        APPLY("fabric8:apply");

        private final String goal;
        private final boolean isFmpGoal;

        private Goal(String goal, boolean isFmpGoal) {
            this.goal = goal;
            this.isFmpGoal = isFmpGoal;
        }

        private Goal(String goal) {
            this(goal, true);
        }

        public String getGoal() {
            return this.goal;
        }

        public boolean isFmpGoal() {
            return this.isFmpGoal;
        }
    }
}

