/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.maven;

import cz.xtf.io.IOUtils;
import cz.xtf.maven.MavenUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.it.VerificationException;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.JUnitSoftAssertions;
import org.assertj.core.api.StringAssert;

public class SimpleDependencyCheck {
    private JUnitSoftAssertions softly = null;

    public SimpleDependencyCheck() {
    }

    public SimpleDependencyCheck(JUnitSoftAssertions softly) {
        this.softly = softly;
    }

    public void verifyDeploymentHaveRightVersions(Path dir, Path settingsPath, Map<Pattern, String> groupIdRegexToExpectedVersion) throws VerificationException, IOException {
        IOUtils.TMP_DIRECTORY.toFile().mkdirs();
        Path tmp = Files.createTempDirectory(IOUtils.TMP_DIRECTORY, dir.getFileName().toString(), new FileAttribute[0]);
        IOUtils.copy(dir, tmp);
        MavenUtil.forProject(tmp, settingsPath).forkJvm().addCliOptions("-X").executeGoals("dependency:tree");
        Pattern pattern = Pattern.compile(".* (([^ :]+):([^ :]+):([^ :]+):([^ :]+)(:[^ :]+)?(:[^ :]+)?)");
        Files.lines(tmp.resolve("log.txt")).map(line -> pattern.matcher((CharSequence)line)).filter(m -> m.find()).forEach(t -> {
            for (Map.Entry entry : groupIdRegexToExpectedVersion.entrySet()) {
                if (!((Pattern)entry.getKey()).matcher(t.group(1)).matches()) continue;
                String groupId = t.group(2);
                String artifactId = t.group(3);
                String version = t.group(7) != null ? t.group(6).substring(1) : t.group(5);
                if (this.softly != null) {
                    ((StringAssert)this.softly.assertThat(version).as("" + dir + " " + groupId + ":" + artifactId + " version", new Object[0])).isEqualTo(entry.getValue());
                    continue;
                }
                ((AbstractCharSequenceAssert)Assertions.assertThat((String)version).as("" + dir + " " + groupId + ":" + artifactId + " version", new Object[0])).isEqualTo(entry.getValue());
            }
        });
    }
}

