/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift;

import cz.xtf.TestConfiguration;
import cz.xtf.docker.OpenShiftNode;
import cz.xtf.io.IOUtils;
import cz.xtf.openshift.OpenShiftContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftBinaryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftBinaryClient.class);
    private static OpenShiftBinaryClient INSTANCE;
    private final OpenShiftContext context;
    private static String ocBinaryPath;
    private static final File WORKDIR;
    private static final File CONFIG_FILE;

    private OpenShiftBinaryClient(OpenShiftContext context) throws IOException, InterruptedException {
        this.context = context;
        ocBinaryPath = this.getBinary();
    }

    public static OpenShiftBinaryClient getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = new OpenShiftBinaryClient(OpenShiftContext.getContext());
                OpenShiftBinaryClient.login();
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("OpenShift Master URL is malformed", ex);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Can't get oc binary", ex);
            }
            catch (InterruptedException ex) {
                throw new IllegalArgumentException("Init failed", ex);
            }
        }
        return INSTANCE;
    }

    public void project(String projectName) {
        this.executeCommand("oc project failed", "project", projectName);
    }

    public void executeCommand(String error, String ... args) {
        String[] ocArgs = (String[])ArrayUtils.addAll((Object[])new String[]{ocBinaryPath, "--config=" + CONFIG_FILE.getAbsolutePath()}, (Object[])args);
        try {
            OpenShiftBinaryClient.executeLocalCommand(error, ocArgs);
        }
        catch (IOException | InterruptedException ex) {
            throw new IllegalArgumentException(error, ex);
        }
    }

    public Process executeCommandNoWait(String error, String ... args) {
        String[] ocArgs = (String[])ArrayUtils.addAll((Object[])new String[]{ocBinaryPath, "--config=" + CONFIG_FILE.getAbsolutePath()}, (Object[])args);
        try {
            return OpenShiftBinaryClient.executeLocalCommand(error, false, false, false, ocArgs);
        }
        catch (IOException | InterruptedException ex) {
            throw new IllegalArgumentException(error, ex);
        }
    }

    public Process executeCommandNoWaitWithOutputAndError(String error, String ... args) {
        String[] ocArgs = (String[])ArrayUtils.addAll((Object[])new String[]{ocBinaryPath, "--config=" + CONFIG_FILE.getAbsolutePath()}, (Object[])args);
        try {
            return OpenShiftBinaryClient.executeLocalCommand(error, false, true, true, ocArgs);
        }
        catch (IOException | InterruptedException ex) {
            throw new IllegalArgumentException(error, ex);
        }
    }

    /*
     * Exception decompiling
     */
    public String executeCommandWithReturn(String error, String ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void executeCommandAndConsumeOutput(String error, CommandResultConsumer consumer, String ... args) {
        String[] ocArgs = (String[])ArrayUtils.addAll((Object[])new String[]{ocBinaryPath, "--config=" + CONFIG_FILE.getAbsolutePath()}, (Object[])args);
        try {
            Process process = OpenShiftBinaryClient.executeLocalCommand(error, false, true, false, ocArgs);
            try (InputStream is = process.getInputStream();){
                consumer.consume(is);
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new IllegalArgumentException(error, ex);
        }
    }

    private static Process executeLocalCommand(String error, boolean wait, boolean needOutput, boolean needError, String ... args) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(args);
        if (!needOutput) {
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        if (!needError) {
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        LOGGER.debug("executing local command: {}", (Object)String.join((CharSequence)" ", args));
        Process process = pb.start();
        if (wait && process.waitFor() != 0) {
            throw new IllegalStateException(error);
        }
        return process;
    }

    public static Process executeLocalCommand(String error, String ... args) throws IOException, InterruptedException {
        return OpenShiftBinaryClient.executeLocalCommand(error, true, false, false, args);
    }

    private static void login() throws IOException, InterruptedException {
        String masterIp = TestConfiguration.openshiftOnline() ? TestConfiguration.masterUrl() : "https://" + InetAddress.getByName(new URL(TestConfiguration.masterUrl()).getHost()).getHostAddress() + ":8443";
        LOGGER.debug("Master IP: {}", (Object)masterIp);
        OpenShiftBinaryClient.loginStatic(masterIp, TestConfiguration.masterUsername(), TestConfiguration.masterPassword(), TestConfiguration.getMasterToken());
    }

    public void login(String masterUrl, String masterUserName, String masterPassword, String masterToken) throws IOException, InterruptedException {
        OpenShiftBinaryClient.loginStatic(masterUrl, masterUserName, masterPassword, masterToken);
    }

    public void loginDefault() throws IOException, InterruptedException {
        OpenShiftBinaryClient.login();
    }

    private static void loginStatic(String masterUrl, String masterUserName, String masterPassword, String masterToken) throws IOException, InterruptedException {
        if (TestConfiguration.openshiftOnline()) {
            OpenShiftBinaryClient.executeLocalCommand("oc login failed!", ocBinaryPath, "login", masterUrl, "--token=" + masterToken, "--config=" + CONFIG_FILE);
        } else {
            OpenShiftBinaryClient.executeLocalCommand("oc login failed!", ocBinaryPath, "login", masterUrl, "--username=" + masterUserName, "--password=" + masterPassword, "--insecure-skip-tls-verify=true", "--config=" + CONFIG_FILE);
        }
    }

    private String getBinary() throws IOException, InterruptedException {
        if (SystemUtils.IS_OS_MAC || TestConfiguration.openshiftOnline()) {
            File defaultOcFile = new File(TestConfiguration.ocBinaryLocation());
            if (!defaultOcFile.exists()) {
                LOGGER.error("Hipsterish OS detected, appropriate binary should be downloaded manually and placed to " + TestConfiguration.ocBinaryLocation());
                throw new IllegalArgumentException("OC binary not found for current OS");
            }
            return defaultOcFile.getAbsolutePath();
        }
        File ocFile = new File(WORKDIR, "oc");
        if (ocFile.exists()) {
            LOGGER.debug("Client file already present");
            String[] parts = OpenShiftNode.master().executeCommand("wc -c /usr/bin/oc").split(" ");
            if (parts.length == 2 && (long)Integer.parseInt(parts[0]) == ocFile.length()) {
                LOGGER.debug("Local and remote client have the sime size, using the local one");
                return ocFile.getPath();
            }
        }
        if (WORKDIR.exists()) {
            FileUtils.deleteDirectory((File)WORKDIR);
        }
        if (!WORKDIR.mkdirs()) {
            throw new IOException("Cannot mkdirs " + WORKDIR);
        }
        OpenShiftNode.master().executeCommand("cat /usr/bin/oc", (InputStream istream) -> FileUtils.copyInputStreamToFile((InputStream)istream, (File)ocFile));
        OpenShiftBinaryClient.executeLocalCommand("Error trying to chmod local oc copy", "chmod", "+x", ocFile.getPath());
        return ocFile.getPath();
    }

    static {
        WORKDIR = IOUtils.TMP_DIRECTORY.resolve("oc").toFile();
        CONFIG_FILE = new File(WORKDIR, "oc.config");
    }

    @FunctionalInterface
    public static interface CommandResultConsumer {
        public void consume(InputStream var1) throws IOException;
    }
}

