/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift;

import cz.xtf.TestConfiguration;
import cz.xtf.TestParent;
import cz.xtf.docker.OpenShiftNode;
import cz.xtf.http.HttpClient;
import cz.xtf.http.HttpUtil;
import cz.xtf.openshift.OpenShiftContext;
import cz.xtf.time.TimeUtil;
import cz.xtf.tuple.Tuple;
import cz.xtf.wait.WaitUtil;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.DoneableProjectRequest;
import io.fabric8.openshift.api.model.DoneableRoleBinding;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.ParameterValue;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.observables.StringObservable;

public class OpenshiftUtil
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenshiftUtil.class);
    private static final String ANNOTATION_BUILD_POD = "openshift.io/build.pod-name";
    private static OpenshiftUtil INSTANCE;
    private final String server;
    private NamespacedOpenShiftClient defaultClient;
    private NamespacedOpenShiftClient adminClient;
    private OpenShiftContext context;

    private OpenshiftUtil(String server, OpenShiftContext context) throws MalformedURLException {
        new URL(server);
        this.server = server;
        this.context = context;
    }

    public static OpenshiftUtil getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = new OpenshiftUtil(TestConfiguration.masterUrl(), OpenShiftContext.getContext());
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("OpenShift Master URL is malformed", ex);
            }
        }
        return INSTANCE;
    }

    public String getServer() {
        return this.server;
    }

    public OpenShiftContext getContext() {
        return this.context;
    }

    public void setOpenShiftContext(OpenShiftContext context) {
        if (context != null) {
            this.context = context;
            if (this.defaultClient != null) {
                this.defaultClient.close();
            }
            this.defaultClient = null;
        }
    }

    public String getAdminToken() {
        return this.getToken(TestConfiguration.adminUsername(), TestConfiguration.adminPassword());
    }

    public String getDefaultToken() {
        return this.getToken(TestConfiguration.masterUsername(), TestConfiguration.masterPassword());
    }

    public String getToken(String username, String password) {
        try {
            String url = TestConfiguration.masterUrl() + "/oauth/authorize?response_type=token&client_id=openshift-challenging-client";
            List<Header> headers = HttpClient.get(url).basicAuth(username, password).preemptiveAuth().disableRedirect().responseHeaders();
            Optional<Header> location = headers.stream().filter(h -> "Location".equals(h.getName())).findFirst();
            if (location.isPresent()) {
                LOGGER.debug("Location: {}", (Object)location.get().getValue());
                String token = StringUtils.substringBetween((String)location.get().getValue(), (String)"#access_token=", (String)"&");
                LOGGER.info("Oauth token: {}", (Object)token);
                return token;
            }
            LOGGER.info("Location header with token not found");
            return null;
        }
        catch (IOException e) {
            LOGGER.error("Error getting token from master", (Throwable)e);
            return null;
        }
    }

    public <R> R withDefaultUser(Function<NamespacedOpenShiftClient, R> f) {
        if (this.defaultClient == null) {
            OpenShiftConfigBuilder openShiftConfigBuilder = (OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(TestConfiguration.masterUrl())).withTrustCerts(true)).withRequestTimeout(120000)).withNamespace(this.context.getNamespace());
            if (TestConfiguration.openshiftOnline()) {
                openShiftConfigBuilder.withOauthToken(this.context.getToken());
            } else {
                ((OpenShiftConfigBuilder)openShiftConfigBuilder.withPassword(this.context.getPassword())).withUsername(this.context.getUsername());
            }
            this.defaultClient = new DefaultOpenShiftClient(openShiftConfigBuilder.build());
        }
        return f.apply(this.defaultClient);
    }

    public <R> R withAdminUser(Function<NamespacedOpenShiftClient, R> f) {
        if (TestConfiguration.openshiftOnline()) {
            throw new IllegalArgumentException("Openshift online does not support admin users.");
        }
        if (this.adminClient == null) {
            OpenShiftConfig config = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(TestConfiguration.masterUrl())).withTrustCerts(true)).withUsername(TestConfiguration.adminUsername())).withPassword(TestConfiguration.adminPassword())).build();
            this.adminClient = new DefaultOpenShiftClient(config);
        }
        return f.apply(this.adminClient);
    }

    public Collection<HasMetadata> createResources(HasMetadata ... resources) {
        return this.createResources(Arrays.asList(resources));
    }

    public Collection<HasMetadata> createResources(List<HasMetadata> resources) {
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(resources)).build();
        List created = this.createResources(list).getItems();
        created.stream().filter(x -> x.getMetadata().getLabels() != null && x.getMetadata().getLabels().containsKey("synchronousId")).forEach(x -> {
            String deploymentId = (String)x.getMetadata().getLabels().get("synchronousId");
            try {
                LOGGER.info("Waiting for a startup of pod with syncId '{}'", (Object)deploymentId);
                WaitUtil.waitFor(WaitUtil.isAPodReady("synchronousId", deploymentId));
            }
            catch (Exception e) {
                throw new IllegalStateException("Timeout while waiting for deployment of " + x.getMetadata().getName());
            }
        });
        return created;
    }

    public KubernetesList createResources(KubernetesList list) {
        return this.withDefaultUser(client -> (KubernetesList)client.lists().create((Object[])new KubernetesList[]{list}));
    }

    public Project getProject(String name) {
        return this.withAdminUser(client -> {
            Optional<Project> opt = ((ProjectList)client.projects().list()).getItems().stream().filter(proj -> proj.getMetadata().getName().equals(name)).findFirst();
            if (opt.isPresent()) {
                return opt.get();
            }
            return null;
        });
    }

    public void deleteProject(String name) {
        this.deleteProject(this.getProject(name));
    }

    public void deleteProject(Project project) {
        this.withAdminUser(client -> (Boolean)client.projects().delete((Object[])new Project[]{project}));
        String name = project.getMetadata().getName();
        try {
            WaitUtil.waitFor(() -> this.getProject(name) == null);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Unable to delete project " + name);
        }
    }

    public Project createProject(String name, boolean recreateIfExists) {
        Project existing = this.getProject(name);
        if (existing != null) {
            if (recreateIfExists) {
                this.deleteProject(existing);
            } else {
                return existing;
            }
        }
        this.withAdminUser(client -> ((DoneableProjectRequest)((ProjectRequestFluent.MetadataNested)((DoneableProjectRequest)client.projectrequests().createNew()).withNewMetadata().withName(name)).endMetadata()).done());
        this.addRoleToUser(name, "admin", TestConfiguration.masterUsername());
        return this.getProject(name);
    }

    public void addRoleToUser(String namespace, String role, String name) {
        RoleBinding roleBinding = this.getOrCreateRoleBinding(namespace, role);
        this.addSubjectToRoleBinding(roleBinding, "User", name);
        this.addUserNameToRoleBinding(roleBinding, name);
        this.updateRoleBinding(roleBinding);
    }

    public void addRoleToUser(String role, String name) {
        this.addRoleToUser(this.getContext().getNamespace(), role, name);
    }

    public ImageStream createImageStream(ImageStream imageStream) {
        return this.createImageStream(imageStream, this.context.getNamespace());
    }

    public ImageStream createImageStream(ImageStream imageStream, String namespace) {
        return this.withDefaultUser(client -> (ImageStream)((NamespacedOpenShiftClient)client.inNamespace(namespace)).imageStreams().create((Object[])new ImageStream[]{imageStream}));
    }

    public ImageStream getImageStream(String name) {
        return this.getImageStream(name, this.context.getNamespace());
    }

    public ImageStream getImageStream(String name, String namespace) {
        return this.withDefaultUser(client -> {
            Optional<ImageStream> opt = ((ImageStreamList)((NamespacedOpenShiftClient)client.inNamespace(namespace)).imageStreams().list()).getItems().stream().filter(is -> is.getMetadata().getName().equals(name)).findFirst();
            if (opt.isPresent()) {
                return opt.get();
            }
            return null;
        });
    }

    public Collection<ImageStream> getImageStreams() {
        return this.getImageStreams(this.context.getNamespace());
    }

    public Collection<ImageStream> getImageStreams(String namespace) {
        LOGGER.debug("Getting image streams for namespace {}", (Object)namespace);
        return this.withDefaultUser(client -> ((ImageStreamList)client.imageStreams().list()).getItems());
    }

    public boolean deleteImageStream(String name) {
        return this.deleteImageStream(this.getImageStream(name));
    }

    public boolean deleteImageStream(ImageStream imageStream) {
        return this.deleteImageStream(imageStream, this.context.getNamespace());
    }

    public boolean deleteImageStream(ImageStream imageStream, String namespace) {
        return this.withDefaultUser(client -> (Boolean)((NamespacedOpenShiftClient)client.inNamespace(namespace)).imageStreams().delete((Object[])new ImageStream[]{imageStream}));
    }

    public Pod createPod(Pod pod) {
        return this.withDefaultUser(client -> (Pod)client.pods().create((Object[])new Pod[]{pod}));
    }

    public Collection<Pod> getPods() {
        return this.getPods(this.context.getNamespace());
    }

    public Collection<Pod> getPods(String namespace) {
        LOGGER.debug("Getting pods for namespace {}", (Object)namespace);
        return this.withDefaultUser(client -> ((PodList)((NamespacedOpenShiftClient)client.inNamespace(namespace)).pods().list()).getItems());
    }

    public Pod getPod(String podName) {
        return this.getPod(podName, this.context.getNamespace());
    }

    public Pod getPod(String podName, String namespace) {
        return this.withDefaultUser(client -> (Pod)((PodResource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).pods().withName(podName)).get());
    }

    public List<Pod> findPods(Map<String, String> labels) {
        return this.findPods(labels, this.context.getNamespace());
    }

    private List<Pod> findPods(Map<String, String> labels, String namespace) {
        return this.withDefaultUser(client -> ((PodList)((FilterWatchListDeletable)((NamespacedOpenShiftClient)client.inNamespace(namespace)).pods().withLabels(labels)).list()).getItems());
    }

    public Pod findNamedPod(String name) {
        List<Pod> pods = this.findNamedPods(name);
        if (pods.size() != 1) {
            throw new IllegalStateException("Expected one named pod but got " + pods.size());
        }
        return (Pod)pods.iterator().next();
    }

    public List<Pod> findNamedPods(String name) {
        return this.findPods(Collections.singletonMap("name", name));
    }

    public Pod findRandomlyChosenNamedPod(String name) {
        List<Pod> pods = this.findNamedPods(name);
        return pods.get(new Random().nextInt(pods.size()));
    }

    public void deletePod(Pod pod) {
        this.withDefaultUser(client -> (Boolean)client.pods().delete((Object[])new Pod[]{pod}));
    }

    public void deletePod(Pod pod, long gracePeriod) {
        ((Deletable)this.withDefaultUserPod(pod).withGracePeriod(gracePeriod)).delete();
    }

    public void deletePod(Map<String, String> labels) {
        this.deletePod(this.findPods(labels).get(0));
    }

    public Secret createSecret(Secret secret) {
        return this.withDefaultUser(client -> (Secret)client.secrets().create((Object[])new Secret[]{secret}));
    }

    public Collection<Secret> getSecrets() {
        return this.getSecrets(this.context.getNamespace());
    }

    public Collection<Secret> getSecrets(String namespace) {
        return this.withDefaultUser(client -> ((SecretList)((NamespacedOpenShiftClient)client.inNamespace(namespace)).secrets().list()).getItems());
    }

    public void deleteSecret(Secret secret) {
        this.withDefaultUser(client -> (Boolean)client.secrets().delete((Object[])new Secret[]{secret}));
    }

    public Collection<Service> getServices() {
        return this.withDefaultUser(client -> ((ServiceList)client.services().list()).getItems());
    }

    public Collection<Service> getServices(String namespace) {
        return this.withDefaultUser(client -> ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(namespace)).list()).getItems());
    }

    public Service getService(String name) {
        return this.withDefaultUser(client -> (Service)((Resource)client.services().withName(name)).get());
    }

    public Service createService(Service service) {
        return this.withDefaultUser(client -> (Service)client.services().create((Object[])new Service[]{service}));
    }

    public void deleteService(Service service) {
        this.withDefaultUser(client -> (Boolean)client.services().delete((Object[])new Service[]{service}));
    }

    public void deleteService(String name) {
        this.withDefaultUser(client -> (Boolean)((Resource)client.services().withName(name)).delete());
    }

    public Collection<Endpoints> getEndpoints() {
        return this.withDefaultUser(client -> ((EndpointsList)client.endpoints().list()).getItems());
    }

    public Endpoints getEndpoint(String name) {
        return this.withDefaultUser(client -> (Endpoints)((Resource)client.endpoints().withName(name)).get());
    }

    public Endpoints createEndpoint(Endpoints endpoint) {
        return this.withDefaultUser(client -> (Endpoints)client.endpoints().create((Object[])new Endpoints[]{endpoint}));
    }

    public void deleteEndpoint(Endpoints endpoint) {
        this.withDefaultUser(client -> (Boolean)client.endpoints().delete((Object[])new Endpoints[]{endpoint}));
    }

    public Route createRoute(Route route) {
        return this.withDefaultUser(client -> (Route)client.routes().create((Object[])new Route[]{route}));
    }

    public Collection<Route> getRoutes() {
        return this.getRoutes(this.context.getNamespace());
    }

    public Stream<Route> getRoutesNamedWithPrefix(String prefix) {
        return this.getRoutes().stream().filter(x -> x.getMetadata().getName().startsWith(prefix));
    }

    public Route getRoute(String name) {
        List candidates = this.getRoutesNamedWithPrefix(name).collect(Collectors.toList());
        if (candidates.size() == 1) {
            return (Route)candidates.get(0);
        }
        throw new IllegalArgumentException("Cannot find unique route, there is " + candidates.size() + "candidate(s)");
    }

    public Route getExactRoute(String name) {
        return this.withDefaultUser(client -> (Route)((Resource)client.routes().withName(name)).get());
    }

    public Collection<Route> getRoutes(String namespace) {
        return this.withDefaultUser(client -> ((RouteList)((NamespacedOpenShiftClient)client.inNamespace(namespace)).routes().list()).getItems());
    }

    public void deleteRoute(Route route) {
        this.withDefaultUser(client -> (Boolean)client.routes().delete((Object[])new Route[]{route}));
    }

    public Collection<ReplicationController> getReplicationControllers() {
        return this.withDefaultUser(client -> ((ReplicationControllerList)client.replicationControllers().list()).getItems());
    }

    public Collection<ReplicationController> getReplicationControllers(String namespace) {
        return this.withDefaultUser(client -> ((ReplicationControllerList)((NonNamespaceOperation)client.replicationControllers().inNamespace(namespace)).list()).getItems());
    }

    public ReplicationController scaleReplicationController(ReplicationController rc, int replicas) {
        return this.withDefaultUser(client -> (ReplicationController)((RollableScalableResource)client.replicationControllers().withName(rc.getMetadata().getName())).scale(replicas));
    }

    public void deleteReplicationController(ReplicationController rc) {
        this.withDefaultUser(client -> (Boolean)((RollableScalableResource)client.replicationControllers().withName(rc.getMetadata().getName())).delete());
    }

    public void deleteReplicationController(boolean cascading, ReplicationController rc) {
        this.withDefaultUser(client -> (Boolean)((EditReplacePatchDeletable)((RollableScalableResource)client.replicationControllers().withName(rc.getMetadata().getName())).cascading(cascading)).delete());
    }

    public ReplicationController namedReplicationController(String name) throws IllegalStateException {
        ReplicationController result = this.withDefaultUser(client -> (ReplicationController)((RollableScalableResource)client.replicationControllers().withName(name)).get());
        if (result == null) {
            throw new IllegalStateException("Named replication not found (" + name + ")");
        }
        return result;
    }

    public DeploymentConfig namedDeploymentConfig(String name) throws IllegalStateException {
        DeploymentConfig result = this.withDefaultUser(client -> (DeploymentConfig)((DeployableScalableResource)client.deploymentConfigs().withName(name)).get());
        if (result == null) {
            throw new IllegalStateException("Named replication not found (" + name + ")");
        }
        return result;
    }

    public DeploymentConfig createDeploymentConfig(DeploymentConfig deploymentConfig) {
        return this.withDefaultUser(client -> (DeploymentConfig)client.deploymentConfigs().create((Object[])new DeploymentConfig[]{deploymentConfig}));
    }

    public Collection<DeploymentConfig> getDeployments() {
        return this.withDefaultUser(client -> ((DeploymentConfigList)client.deploymentConfigs().list()).getItems());
    }

    public Collection<DeploymentConfig> getDeployments(String namespace) {
        return this.withDefaultUser(client -> ((DeploymentConfigList)((NamespacedOpenShiftClient)client.inNamespace(namespace)).deploymentConfigs().list()).getItems());
    }

    public void deleteDeploymentConfig(DeploymentConfig deploymentConfig) {
        this.withDefaultUser(client -> (Boolean)((EditReplacePatchDeletable)((DeployableScalableResource)client.deploymentConfigs().withName(deploymentConfig.getMetadata().getName())).cascading(true)).delete());
    }

    public void deleteDeploymentConfig(boolean cascading, DeploymentConfig deploymentConfig) {
        this.withDefaultUser(client -> (Boolean)((EditReplacePatchDeletable)((DeployableScalableResource)client.deploymentConfigs().withName(deploymentConfig.getMetadata().getName())).cascading(cascading)).delete());
    }

    public DeploymentConfig updateDeploymentconfig(DeploymentConfig dc) {
        return this.withDefaultUser(client -> ((DoneableDeploymentConfig)((DoneableDeploymentConfig)((DoneableDeploymentConfig)((DeployableScalableResource)client.deploymentConfigs().withName(dc.getMetadata().getName())).edit()).withMetadata(dc.getMetadata())).withSpec(dc.getSpec())).done());
    }

    public Map<String, String> getDeploymentEnvVars(String name) {
        return ((Container)this.namedDeploymentConfig(name).getSpec().getTemplate().getSpec().getContainers().get(0)).getEnv().stream().collect(Collectors.toMap(EnvVar::getName, EnvVar::getValue));
    }

    public void updateDeploymentEnvVars(String name, Map<String, String> vars) {
        DeploymentConfig dc = this.namedDeploymentConfig(name);
        ((Container)dc.getSpec().getTemplate().getSpec().getContainers().get(0)).setEnv(vars.entrySet().stream().map(x -> ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)x.getKey())).withValue((String)x.getValue())).build()).collect(Collectors.toList()));
        this.updateDeploymentconfig(dc);
    }

    public Collection<Build> getBuilds() {
        return this.getBuilds(this.context.getNamespace());
    }

    public Collection<Build> getBuilds(String namespace) {
        return this.withDefaultUser(client -> ((BuildList)((NamespacedOpenShiftClient)client.inNamespace(namespace)).builds().list()).getItems());
    }

    public Build getBuild(String buildName) {
        return this.getBuild(buildName, this.context.getNamespace());
    }

    public Build getBuild(String buildName, String namespace) {
        return this.withDefaultUser(client -> (Build)((BuildResource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).builds().withName(buildName)).get());
    }

    public Build startBuild(BuildConfig buildConfig) {
        return this.startBuild(buildConfig, this.context.getNamespace());
    }

    public synchronized Build startBuild(BuildConfig buildConfig, String namespace) {
        BuildConfig refreshed = this.withDefaultUser(client -> (BuildConfig)((BuildConfigResource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).buildConfigs().withName(buildConfig.getMetadata().getName())).get());
        long buildVersion = refreshed.getStatus().getLastVersion();
        BuildRequest request = ((BuildRequestBuilder)((BuildRequestFluent.MetadataNested)new BuildRequestBuilder().withNewMetadata().withName(buildConfig.getMetadata().getName())).endMetadata()).build();
        return this.withDefaultUser(client -> {
            BuildWatcher buildWatcher = new BuildWatcher(buildConfig.getMetadata().getName(), buildVersion);
            Watch watch = (Watch)((NamespacedOpenShiftClient)client.inNamespace(namespace)).builds().watch((Object)buildWatcher);
            ((BuildConfigResource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).buildConfigs().withName(refreshed.getMetadata().getName())).instantiate((Object)request);
            try {
                WaitUtil.waitFor(() -> buildWatcher.getBuild() != null);
            }
            catch (TimeoutException ex) {
                throw new RuntimeException("Failed to obtain build name", ex);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for Build to appear", (Throwable)ex);
            }
            finally {
                watch.close();
            }
            return buildWatcher.getBuild();
        });
    }

    public void deleteBuild(Build build) {
        this.deleteBuild(build, this.context.getNamespace());
    }

    public void deleteBuild(Build build, String namespace) {
        this.withDefaultUser(client -> (Boolean)((NamespacedOpenShiftClient)client.inNamespace(namespace)).builds().delete((Object[])new Build[]{build}));
    }

    public BuildConfig createBuildConfig(BuildConfig buildConfig) {
        return this.createBuildConfig(buildConfig, this.context.getNamespace());
    }

    public BuildConfig createBuildConfig(BuildConfig buildConfig, String namespace) {
        return this.withDefaultUser(client -> (BuildConfig)((NamespacedOpenShiftClient)client.inNamespace(namespace)).buildConfigs().create((Object[])new BuildConfig[]{buildConfig}));
    }

    public BuildConfig getBuildConfig(String name, String namespace) {
        return this.withDefaultUser(client -> (BuildConfig)((BuildConfigResource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).buildConfigs().withName(name)).get());
    }

    public BuildConfig getBuildConfig(String name) {
        return this.withDefaultUser(client -> (BuildConfig)((BuildConfigResource)client.buildConfigs().withName(name)).get());
    }

    public Collection<BuildConfig> getBuildConfigs() {
        return this.withDefaultUser(client -> ((BuildConfigList)client.buildConfigs().list()).getItems());
    }

    public Collection<BuildConfig> getBuildConfigs(String namespace) {
        return this.withDefaultUser(client -> ((BuildConfigList)((NonNamespaceOperation)client.buildConfigs().inNamespace(namespace)).list()).getItems());
    }

    public Map<String, String> getSourceBuildConfigEnvVars(String name) {
        return this.getBuildConfig(name).getSpec().getStrategy().getSourceStrategy().getEnv().stream().collect(Collectors.toMap(EnvVar::getName, EnvVar::getValue));
    }

    public void updateSourceBuildConfigEnvVars(String name, Map<String, String> vars) {
        this.updateSourceBuildConfigEnvVars(name, this.context.getNamespace(), vars);
    }

    public void updateSourceBuildConfigEnvVars(String name, String namespace, Map<String, String> vars) {
        BuildConfig bc = this.getBuildConfig(name, namespace);
        bc.getSpec().getStrategy().getSourceStrategy().setEnv(vars.entrySet().stream().map(x -> ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)x.getKey())).withValue((String)x.getValue())).build()).collect(Collectors.toList()));
        this.updateBuildConfig(bc);
    }

    public BuildConfig updateBuildConfig(BuildConfig bc) {
        return this.withDefaultUser(client -> ((DoneableBuildConfig)((DoneableBuildConfig)((DoneableBuildConfig)((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(bc.getMetadata().getNamespace())).withName(bc.getMetadata().getName())).edit()).withMetadata(bc.getMetadata())).withSpec(bc.getSpec())).done());
    }

    public void scaleDeploymentConfig(String deploymentConfig, int replicas) {
        OpenShiftNode.master().executeCommand(String.format("sudo oc scale -n %s --replicas=%s dc %s", this.getContext().getNamespace(), replicas, deploymentConfig));
    }

    public void addAnyUIDToServiceAccount(String serviceAccount) {
        OpenShiftNode.master().executeCommand(String.format("sudo oadm policy add-scc-to-user %s system:serviceaccount:%s:%s", "anyuid", this.getContext().getNamespace(), serviceAccount));
    }

    public void deleteBuildConfig(BuildConfig buildConfig) {
        this.deleteBuildConfig(buildConfig, this.context.getNamespace());
    }

    public void deleteBuildConfig(BuildConfig buildConfig, String namespace) {
        this.withDefaultUser(client -> (Boolean)((NamespacedOpenShiftClient)client.inNamespace(namespace)).buildConfigs().delete((Object[])new BuildConfig[]{buildConfig}));
    }

    public ServiceAccount createServiceAccount(ServiceAccount serviceAccount) {
        return this.withDefaultUser(client -> (ServiceAccount)client.serviceAccounts().create((Object[])new ServiceAccount[]{serviceAccount}));
    }

    public Collection<ServiceAccount> getServiceAccounts() {
        return this.withDefaultUser(client -> ((ServiceAccountList)client.serviceAccounts().list()).getItems());
    }

    public void deleteServiceAccount(ServiceAccount serviceAccount) {
        this.withDefaultUser(client -> (Boolean)client.serviceAccounts().delete((Object[])new ServiceAccount[]{serviceAccount}));
    }

    public void addRoleToServiceAccount(String role, String serviceAccountName) {
        this.addRoleToServiceAccount(this.getContext().getNamespace(), role, serviceAccountName);
    }

    public void addRoleToServiceAccount(String namespace, String role, String serviceAccountName) {
        RoleBinding roleBinding = this.getOrCreateRoleBinding(namespace, role);
        this.addSubjectToRoleBinding(roleBinding, "ServiceAccount", serviceAccountName);
        this.addUserNameToRoleBinding(roleBinding, String.format("system:serviceaccount:%s:%s", namespace, serviceAccountName));
        this.updateRoleBinding(roleBinding);
    }

    public void addRoleToGroup(String role, String groupName) {
        this.addRoleToGroup(this.getContext().getNamespace(), role, groupName);
    }

    public void addRoleToGroup(String namespace, String role, String groupName) {
        RoleBinding roleBinding = this.getOrCreateRoleBinding(namespace, role);
        this.addSubjectToRoleBinding(roleBinding, "SystemGroup", groupName);
        this.addGroupNameToRoleBinding(roleBinding, groupName);
        this.updateRoleBinding(roleBinding);
    }

    private RoleBinding getOrCreateRoleBinding(String namespace, String role) {
        RoleBinding roleBinding = this.withAdminUser(client -> (RoleBinding)((Resource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).roleBindings().withName(role)).get());
        if (roleBinding == null) {
            return this.withAdminUser(client -> ((DoneableRoleBinding)((RoleBindingFluent.RoleRefNested)((DoneableRoleBinding)((RoleBindingFluent.MetadataNested)((DoneableRoleBinding)((NamespacedOpenShiftClient)client.inNamespace(namespace)).roleBindings().createNew()).withNewMetadata().withName(role)).endMetadata()).withNewRoleRef().withName(role)).endRoleRef()).done());
        }
        return roleBinding;
    }

    public RoleBinding updateRoleBinding(RoleBinding roleBinding) {
        return this.withAdminUser(client -> (RoleBinding)((Resource)((NamespacedOpenShiftClient)client.inNamespace(roleBinding.getMetadata().getNamespace())).roleBindings().withName(roleBinding.getMetadata().getName())).replace((Object)roleBinding));
    }

    private void addSubjectToRoleBinding(RoleBinding roleBinding, String entityKind, String entityName) {
        ObjectReference subject = ((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind(entityKind)).withName(entityName)).build();
        if (!roleBinding.getSubjects().stream().anyMatch(x -> x.getName().equals(subject.getName()) && x.getKind().equals(subject.getKind()))) {
            roleBinding.getSubjects().add(subject);
        }
    }

    private void addUserNameToRoleBinding(RoleBinding roleBinding, String userName) {
        if (roleBinding.getUserNames() == null) {
            roleBinding.setUserNames(new ArrayList());
        }
        if (!roleBinding.getUserNames().contains(userName)) {
            roleBinding.getUserNames().add(userName);
        }
    }

    private void addGroupNameToRoleBinding(RoleBinding roleBinding, String groupName) {
        if (roleBinding.getGroupNames() == null) {
            roleBinding.setGroupNames(new ArrayList());
        }
        if (!roleBinding.getGroupNames().contains(groupName)) {
            roleBinding.getGroupNames().add(groupName);
        }
    }

    public void removeRoleFromServiceAccount(String role, String serviceAccountName) {
        this.removeRoleFromServiceAccount(this.getContext().getNamespace(), role, serviceAccountName);
    }

    public void removeRoleFromServiceAccount(String namespace, String role, String serviceAccountName) {
        this.removeRoleFromEntity(namespace, role, "ServiceAccount", serviceAccountName, String.format("system:serviceaccount:%s:%s", this.getContext().getNamespace(), serviceAccountName));
    }

    private void removeRoleFromEntity(String namespace, String role, String entityKind, String entityName, String userName) {
        this.withAdminUser(client -> {
            if (((Resource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).roleBindings().withName(role)).get() != null) {
                ((DoneableRoleBinding)((DoneableRoleBinding)((DoneableRoleBinding)((Resource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).roleBindings().withName(role)).edit()).removeFromSubjects(new ObjectReference[]{((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind(entityKind)).withName(entityName)).build()})).removeFromUserNames(new String[]{userName})).done();
            } else {
                LOGGER.warn("No role '{}' in namespace '{}'.", (Object)role, (Object)namespace);
            }
            return null;
        });
    }

    public ResourceQuota createHardResourceQuota(String namespace, String quotaName, String resourceName, String value) {
        ResourceQuota quota = this.withAdminUser(client -> (ResourceQuota)((Resource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).resourceQuotas().withName(quotaName)).get());
        if (quota != null) {
            return this.withAdminUser(client -> ((DoneableResourceQuota)((ResourceQuotaFluent.SpecNested)((DoneableResourceQuota)((Resource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).resourceQuotas().withName(quotaName)).edit()).editSpec().addToHard(resourceName, new Quantity(value))).endSpec()).done());
        }
        return this.withAdminUser(client -> ((DoneableResourceQuota)((ResourceQuotaFluent.SpecNested)((DoneableResourceQuota)((ResourceQuotaFluent.MetadataNested)((DoneableResourceQuota)((NamespacedOpenShiftClient)client.inNamespace(namespace)).resourceQuotas().createNew()).withNewMetadata().withName(quotaName)).endMetadata()).withNewSpec().addToHard("pods", new Quantity(value))).endSpec()).done());
    }

    public PersistentVolumeClaim createPersistentVolumeClaim(PersistentVolumeClaim pvc) {
        return this.withDefaultUser(client -> (PersistentVolumeClaim)client.persistentVolumeClaims().create((Object[])new PersistentVolumeClaim[]{pvc}));
    }

    public Collection<PersistentVolumeClaim> getPersistentVolumeClaims() {
        return this.withDefaultUser(client -> ((PersistentVolumeClaimList)client.persistentVolumeClaims().list()).getItems());
    }

    public PersistentVolumeClaim getPersistentVolumeClaim(String name) {
        return this.withDefaultUser(client -> (PersistentVolumeClaim)((Resource)client.persistentVolumeClaims().withName(name)).get());
    }

    public void deletePersistentVolumeClaim(PersistentVolumeClaim pvc) {
        this.withDefaultUser(client -> (Boolean)client.persistentVolumeClaims().delete((Object[])new PersistentVolumeClaim[]{pvc}));
    }

    public KubernetesListMixedOperation getLists() {
        return this.withDefaultUser(client -> client.lists());
    }

    public HorizontalPodAutoscaler createHorizontalPodAutoscaler(HorizontalPodAutoscaler hpa) {
        return this.withDefaultUser(client -> (HorizontalPodAutoscaler)client.autoscaling().horizontalPodAutoscalers().create((Object[])new HorizontalPodAutoscaler[]{hpa}));
    }

    public Collection<HorizontalPodAutoscaler> getHorizontalPodAutoscalers() {
        return this.withDefaultUser(client -> ((HorizontalPodAutoscalerList)client.autoscaling().horizontalPodAutoscalers().list()).getItems());
    }

    public HorizontalPodAutoscaler getHorizontalPodAutoscaler(String name) {
        return this.withDefaultUser(client -> (HorizontalPodAutoscaler)((Resource)client.autoscaling().horizontalPodAutoscalers().withName(name)).get());
    }

    public void deleteHorizontalPodAutoscaler(HorizontalPodAutoscaler hpa) {
        this.withDefaultUser(client -> (Boolean)client.autoscaling().horizontalPodAutoscalers().delete((Object[])new HorizontalPodAutoscaler[]{hpa}));
    }

    public Collection<ConfigMap> getConfigMaps() {
        return this.withDefaultUser(client -> ((ConfigMapList)client.configMaps().list()).getItems());
    }

    public ConfigMap getConfigMap(String name) {
        return this.withDefaultUser(client -> (ConfigMap)((Resource)client.configMaps().withName(name)).get());
    }

    public ConfigMap createConfigMap(ConfigMap configMap) {
        return this.withDefaultUser(client -> (ConfigMap)client.configMaps().create((Object[])new ConfigMap[]{configMap}));
    }

    public void deleteConfigMap(ConfigMap configMap) {
        this.withDefaultUser(client -> (Boolean)client.configMaps().delete((Object[])new ConfigMap[]{configMap}));
    }

    public void updateEnviromentVariable(DeploymentConfig deploymentConfig, String variableName, String variableValue, boolean overwrite) {
        this.updateEnviromentVariable("dc/" + deploymentConfig.getMetadata().getName(), variableName, variableValue, overwrite);
    }

    public void updateEnviromentVariable(ReplicationController replicationController, String variableName, String variableValue, boolean overwrite) {
        this.updateEnviromentVariable("rc/" + replicationController.getMetadata().getName(), variableName, variableValue, overwrite);
    }

    private void updateEnviromentVariable(String resource, String variableName, String variableValue, boolean overwrite) {
        String overWriteString = overwrite ? "--overwrite" : "";
        String cmd = String.format("sudo oc env -n %s %s %s=%s %s", this.getContext().getNamespace(), resource, variableName, variableValue, overWriteString);
        LOGGER.info(String.format("Executing command '%s'", cmd));
        OpenShiftNode.master().executeCommand(cmd);
    }

    public void startRedeployment(String deploymentName) {
        OpenShiftNode.master().executeCommand(String.format("sudo oc deploy %s -n %s --latest=true", deploymentName, this.getContext().getNamespace()));
    }

    public Build startBuildViaGenericWebHook(BuildConfig buildConfig) {
        BuildConfig refreshed = this.withDefaultUser(client -> (BuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildConfig.getMetadata().getName())).get());
        Collection originalBuilds = this.getBuilds().stream().map(build -> build.getMetadata().getName()).collect(Collectors.toList());
        BuildTriggerPolicy trigger = refreshed.getSpec().getTriggers().stream().filter(t -> "Generic".equals(t.getType())).findFirst().get();
        String baseUrl = this.withDefaultUser(client -> client.getOpenshiftUrl().toString());
        String webhookUrl = String.format("%snamespaces/%s/buildconfigs/%s/webhooks/%s/%s", baseUrl, refreshed.getMetadata().getNamespace(), refreshed.getMetadata().getName(), trigger.getGeneric().getSecret(), trigger.getType().toLowerCase());
        try {
            LOGGER.info("Invoking web hook via url {}", (Object)webhookUrl);
            String result = HttpUtil.httpPost(webhookUrl, null, ContentType.APPLICATION_JSON);
            LOGGER.debug("Web hook invoked with return value '{}'", (Object)result);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize HTTP connection", ex);
        }
        String buildConfigName = refreshed.getMetadata().getName();
        List builds = this.getBuilds().stream().filter(build -> !originalBuilds.contains(build.getMetadata().getName()) && build.getMetadata().getName().startsWith(buildConfigName)).collect(Collectors.toList());
        if (builds.size() != 1) {
            throw new IllegalStateException("Expected one build but got " + builds.size());
        }
        LOGGER.info("Started build {}", (Object)((Build)builds.get(0)).getMetadata().getName());
        return (Build)builds.get(0);
    }

    public Build waitForBuildCompletion(Build build, int timeoutInSeconds, boolean exceptionOnFail) {
        return this.waitForBuildCompletion(build, timeoutInSeconds, TimeUnit.SECONDS, exceptionOnFail);
    }

    public Build waitForBuildCompletion(Build build, long timeout, TimeUnit timeUnit, boolean exceptionOnFail) {
        LOGGER.info("Waiting for completion of build {}", (Object)build.getMetadata().getName());
        long startTime = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted while waiting for build completion");
            }
            build = this.getBuild(build.getMetadata().getName(), build.getMetadata().getNamespace());
        } while (System.currentTimeMillis() - startTime < timeUnit.toMillis(timeout) && !"Complete".equals(build.getStatus().getPhase()) && !"Failed".equals(build.getStatus().getPhase()));
        String buildName = build.getMetadata().getName();
        Optional<Pod> buildPod = this.getPods().stream().filter(p -> p.getMetadata().getName().startsWith(buildName)).findFirst();
        if (buildPod.isPresent()) {
            LOGGER.info("Build '{}' ran on node '{}'", (Object)build.getMetadata().getName(), (Object)buildPod.get().getStatus().getHostIP());
        } else {
            LOGGER.debug("Could not find build pod.");
        }
        switch (build.getStatus().getPhase()) {
            case "Complete": {
                try {
                    long start = TimeUtil.parseOpenShiftTimestamp(build.getStatus().getStartTimestamp());
                    long complete = TimeUtil.parseOpenShiftTimestamp(build.getStatus().getCompletionTimestamp());
                    LOGGER.info("Finished build {} in {}", (Object)build.getMetadata().getName(), (Object)TimeUtil.millisToString(complete - start));
                }
                catch (ParseException x) {
                    LOGGER.info("Finished build {}", (Object)build.getMetadata().getName());
                    LOGGER.error("Failed to parse time!", (Throwable)x);
                }
                break;
            }
            case "Failed": {
                if (!exceptionOnFail) break;
                Path logPath = this.saveBuildLog(build);
                LOGGER.error("Build {} has failed, build log is saved at {}", (Object)build.getMetadata().getName(), (Object)logPath);
                LOGGER.debug("Failed build: {}", (Object)build);
                Assertions.fail((String)("Build '" + build.getMetadata().getName() + "' has failed"));
                break;
            }
            default: {
                Assertions.fail((String)"Timed out while waiting for build completion");
            }
        }
        return build;
    }

    public String getBuildLog(Build build) {
        return this.getBuildLog(build, this.context.getNamespace());
    }

    public String getBuildLog(Build build, String namespace) {
        return this.withDefaultUser(client -> (String)((PodResource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).pods().withName((String)((Build)((BuildResource)((NamespacedOpenShiftClient)client.inNamespace(namespace)).builds().withName(build.getMetadata().getName())).get()).getMetadata().getAnnotations().get(ANNOTATION_BUILD_POD))).getLog());
    }

    private PodResource<Pod, DoneablePod> withDefaultUserPod(Pod pod) {
        if (pod.getMetadata().getNamespace() != null) {
            return this.withDefaultUser(c -> (PodResource)((NonNamespaceOperation)c.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName()));
        }
        return this.withDefaultUser(c -> (PodResource)c.pods().withName(pod.getMetadata().getName()));
    }

    public String getRuntimeLog(Pod pod) {
        return (String)this.withDefaultUserPod(pod).getLog();
    }

    public Observable<String> observeRuntimeLog(Pod pod) {
        LogWatch watcher = (LogWatch)this.withDefaultUserPod(pod).watchLog();
        return StringObservable.byLine((Observable)StringObservable.from((Reader)new InputStreamReader(watcher.getOutput())));
    }

    public KubernetesList processTemplate(Template template, Map<String, String> parameters) {
        ParameterValue[] values = this.processParameters(parameters);
        return this.withDefaultUser(client -> {
            ((TemplateResource)client.templates().withName(template.getMetadata().getName())).delete();
            client.templates().create((Object[])new Template[]{template});
            return (KubernetesList)((TemplateResource)client.templates().withName(template.getMetadata().getName())).process(values);
        });
    }

    public KubernetesList processTemplate(String name, Map<String, String> parameters) {
        return this.processTemplate(this.context.getNamespace(), name, parameters);
    }

    public KubernetesList processTemplate(String namespace, String name, Map<String, String> parameters) {
        ParameterValue[] values = this.processParameters(parameters);
        return this.withDefaultUser(client -> (KubernetesList)((TemplateResource)((NonNamespaceOperation)client.templates().inNamespace(namespace)).withName(name)).process(values));
    }

    private ParameterValue[] processParameters(Map<String, String> parameters) {
        return parameters.entrySet().stream().map(entry -> new ParameterValue((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()).toArray(new ParameterValue[parameters.size()]);
    }

    public void cleanProject() {
        this.cleanProject(false);
    }

    public void cleanProject(boolean conditional) {
        if (!conditional || TestConfiguration.cleanNamespace()) {
            this.savePodList();
            this.savePodLogs();
            this.cleanProject(2);
        }
    }

    public void savePodLogs() {
        this.getPods().forEach(this::savePodLog);
    }

    public void savePodList() {
        OpenshiftUtil.getProjectLogsDir().toFile().mkdirs();
        try (FileWriter writer = new FileWriter(OpenshiftUtil.getProjectLogsDir().resolve(TestParent.getCurrentTestClass() + "-pods.log").toFile());){
            for (Pod p : this.getPods()) {
                writer.append(p.toString());
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not write pod list for project", (Throwable)e);
        }
    }

    public void savePodLogs(String phase) {
        this.getPods().forEach(x -> this.savePodLog((Pod)x, phase));
    }

    private void cleanProject(int count) {
        if (this.context.getNamespace().matches("\\s*|\\s*default\\s*")) {
            throw new IllegalStateException("Attempt to clean default namespace!");
        }
        this.getDeployments().forEach(x -> this.deleteDeploymentConfig(false, (DeploymentConfig)x));
        this.getBuildConfigs().forEach(this::deleteBuildConfig);
        this.getReplicationControllers().forEach(x -> this.deleteReplicationController(false, (ReplicationController)x));
        this.getImageStreams().forEach(this::deleteImageStream);
        this.getEndpoints().forEach(this::deleteEndpoint);
        this.getServices().forEach(this::deleteService);
        this.getBuilds().forEach(this::deleteBuild);
        this.getRoutes().forEach(this::deleteRoute);
        this.getPods().forEach(pod -> this.deletePod((Pod)pod, 0L));
        this.getPersistentVolumeClaims().forEach(this::deletePersistentVolumeClaim);
        this.getHorizontalPodAutoscalers().forEach(this::deleteHorizontalPodAutoscaler);
        this.getConfigMaps().forEach(this::deleteConfigMap);
        this.getSecrets().stream().filter(s -> !s.getType().startsWith("kubernetes.io/")).forEach(this::deleteSecret);
        this.getServiceAccounts().stream().filter(sa -> !sa.getMetadata().getName().equals("builder")).filter(sa -> !sa.getMetadata().getName().equals("default")).filter(sa -> !sa.getMetadata().getName().equals("deployer")).forEach(this::deleteServiceAccount);
        if (count > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while cleaning project.", (Throwable)e);
            }
            this.cleanProject(count - 1);
        }
    }

    public void cleanImages(boolean conditional) {
        if (!conditional || TestConfiguration.cleanNamespace()) {
            OpenShiftNode.master().executeCommand(String.format("oc login %s --insecure-skip-tls-verify -u %s -p %s", TestConfiguration.masterUrl(), TestConfiguration.adminUsername(), TestConfiguration.adminPassword()));
            OpenShiftNode.master().executeCommand("oadm prune images --keep-tag-revisions=1 --confirm");
        }
    }

    public Path saveBuildLog(Build build) {
        int suffix = 0;
        Path logFile = null;
        do {
            try {
                OpenshiftUtil.getBuildLogsDir().toFile().mkdirs();
                logFile = Files.createFile(OpenshiftUtil.getBuildLogsDir().resolve(String.format("%s_%s.log", build.getMetadata().getName(), suffix)), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException ex) {
                ++suffix;
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to create log file", (Throwable)ex);
                return null;
            }
        } while (logFile == null);
        try {
            List<String> buildLog = Arrays.asList(this.getBuildLog(build).split("\n"));
            Files.write(logFile, buildLog, Charset.defaultCharset(), new OpenOption[0]);
            return logFile;
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to save the build log", t);
            return null;
        }
    }

    public Path savePodLog(Pod pod) {
        return this.savePodLog(pod, null);
    }

    public Path savePodLog(Pod pod, String phase) {
        Path logFile = null;
        try {
            Path logDir = OpenshiftUtil.getPodLogsDir().resolve(TestParent.getCurrentTestClass());
            logDir.toFile().mkdirs();
            logFile = phase == null ? Files.createFile(logDir.resolve(String.format("%s.log", pod.getMetadata().getName())), new FileAttribute[0]) : Files.createFile(logDir.resolve(String.format("%s-%s.log", phase, pod.getMetadata().getName())), new FileAttribute[0]);
        }
        catch (KubernetesClientException | IOException ex) {
            LOGGER.debug("Unable to create log file", ex);
            return null;
        }
        try {
            List<String> podLog = Arrays.asList(this.getRuntimeLog(pod).split("\n"));
            Files.write(logFile, podLog, Charset.defaultCharset(), new OpenOption[0]);
            return logFile;
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to save logs for pod: {}", (Object)pod.getMetadata().getName());
            LOGGER.debug("Stacktrace: ", t);
            return null;
        }
    }

    public Path savePodLogWithObserver(Pod pod, String phase) {
        Path logFile = null;
        try {
            Path logDir = OpenshiftUtil.getPodLogsDir().resolve(TestParent.getCurrentTestClass());
            logDir.toFile().mkdirs();
            logFile = phase == null ? Files.createFile(logDir.resolve(String.format("%s.log", pod.getMetadata().getName())), new FileAttribute[0]) : Files.createFile(logDir.resolve(String.format("%s-%s.log", phase, pod.getMetadata().getName())), new FileAttribute[0]);
        }
        catch (KubernetesClientException | IOException ex) {
            LOGGER.debug("Unable to create log file", ex);
            return null;
        }
        try {
            ArrayList podLog = new ArrayList();
            this.observeRuntimeLog(pod).forEach(podLog::add);
            Files.write(logFile, podLog, Charset.defaultCharset(), new OpenOption[0]);
            return logFile;
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to save logs for pod: {}", (Object)pod.getMetadata().getName());
            LOGGER.debug("Stacktrace: ", t);
            return null;
        }
    }

    public static final Path getPodLogsDir() {
        return Paths.get("log", "pods");
    }

    public static final Path getBuildLogsDir() {
        return Paths.get("log", "builds");
    }

    public static final Path getProjectLogsDir() {
        return Paths.get("log", "project");
    }

    public List<OpenShiftNode> getNodes() {
        return this.withAdminUser(client -> ((NodeList)client.nodes().list()).getItems()).stream().map(node -> new OpenShiftNode(node.getMetadata().getName(), OpenShiftNode.Status.parseString(node.getStatus().getConditions()), node.getMetadata().getLabels())).collect(Collectors.toList());
    }

    @SafeVarargs
    public final List<OpenShiftNode> getNodes(Tuple.Pair<String, String> ... labels) {
        return this.getNodes().stream().filter(node -> Arrays.stream(labels).allMatch(label -> ((String)label.getSecond()).equals(node.getLabels().get(label.getFirst())))).collect(Collectors.toList());
    }

    public Map<String, OpenShiftNode> getNodesAsMap() {
        return this.getNodes().stream().collect(Collectors.toMap(OpenShiftNode::getHostname, Function.identity()));
    }

    @Override
    public void close() throws Exception {
        if (this.defaultClient != null) {
            this.defaultClient.close();
        }
        if (this.adminClient != null) {
            this.adminClient.close();
        }
    }

    public String getEvents(String projectName) {
        return OpenShiftNode.master().executeCommand(String.format("sudo oc -n %s get events", projectName));
    }

    private static class BuildWatcher
    implements Watcher<Build> {
        private Build build;
        private String buildConfigName;
        private long sinceBuildNumber = -1L;

        BuildWatcher() {
        }

        BuildWatcher(String buildConfigName) {
            this.buildConfigName = buildConfigName;
        }

        BuildWatcher(String buildConfigName, long sinceBuildNumber) {
            this.buildConfigName = buildConfigName;
            this.sinceBuildNumber = sinceBuildNumber;
        }

        public Build getBuild() {
            return this.build;
        }

        public void eventReceived(Watcher.Action action, Build resource) {
            if (this.build == null && (this.buildConfigName == null || this.buildConfigName.equals(resource.getMetadata().getLabels().get("buildconfig")))) {
                long currentBuildNumber;
                String buildNumberAnnotation = (String)resource.getMetadata().getAnnotations().get("openshift.io/build.number");
                if (buildNumberAnnotation != null && (currentBuildNumber = (long)Integer.parseInt(buildNumberAnnotation)) <= this.sinceBuildNumber) {
                    LOGGER.trace("ignoring build {} <= {}", (Object)currentBuildNumber, (Object)this.sinceBuildNumber);
                    return;
                }
                this.build = resource;
            }
        }

        public void onClose(KubernetesClientException cause) {
        }
    }
}

