/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.openshift.builder.AbstractBuilder;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.secret.SecretType;
import io.fabric8.kubernetes.api.model.Secret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class SecretBuilder
extends AbstractBuilder<Secret, SecretBuilder> {
    private SecretType type = SecretType.OPAQUE;
    private Map<String, String> data = new HashMap<String, String>();

    public SecretBuilder(String id) {
        this(null, id);
    }

    SecretBuilder(ApplicationBuilder applicationBuilder, String id) {
        super(applicationBuilder, id);
    }

    public SecretBuilder addData(String key, Path path) throws IOException {
        return this.addData(key, Files.newInputStream(path, new OpenOption[0]));
    }

    public SecretBuilder addData(String key, InputStream data) {
        return this.addData(key, this.getBytes(data));
    }

    public SecretBuilder addData(String key, byte[] data) {
        return this.addEncodedData(key, Base64.encodeBase64String((byte[])data));
    }

    public SecretBuilder addRawData(String key, String data) {
        return this.addEncodedData(key, Base64.encodeBase64String((byte[])data.getBytes(StandardCharsets.UTF_8)));
    }

    public SecretBuilder addEncodedData(String key, String data) {
        this.data.put(key, data);
        return this;
    }

    public SecretBuilder setType(SecretType type) {
        this.type = type;
        return this;
    }

    @Override
    public Secret build() {
        if (this.data.size() == 0) {
            throw new IllegalStateException("secret data cannot be empty");
        }
        return ((io.fabric8.kubernetes.api.model.SecretBuilder)((io.fabric8.kubernetes.api.model.SecretBuilder)((io.fabric8.kubernetes.api.model.SecretBuilder)new io.fabric8.kubernetes.api.model.SecretBuilder().withMetadata(this.metadataBuilder().build())).withType(this.type.toString())).withData(this.data)).build();
    }

    @Override
    protected SecretBuilder getThis() {
        return this;
    }

    private byte[] getBytes(InputStream is) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not process data stream", e);
        }
        return os.toByteArray();
    }
}

