/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder.deployment;

import io.fabric8.kubernetes.api.model.HTTPHeaderBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractProbe {
    protected String probeType;
    protected String path;
    protected String port;
    protected String host;
    protected Map<String, String> httpHeaders;
    protected String[] commandArgs;

    public Probe build() {
        ProbeBuilder builder = new ProbeBuilder();
        if (this.probeType.equals("httpGet")) {
            List headers = this.httpHeaders.entrySet().stream().map(x -> ((HTTPHeaderBuilder)((HTTPHeaderBuilder)new HTTPHeaderBuilder().withName((String)x.getKey())).withValue((String)x.getValue())).build()).collect(Collectors.toList());
            ((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)builder.withNewHttpGet().withPath(this.path)).withPort(this.getPort())).withHost(this.host)).withHttpHeaders(headers)).endHttpGet();
        }
        if (this.probeType.equals("tcpSocket")) {
            ((ProbeFluent.TcpSocketNested)builder.withNewTcpSocket().withPort(this.getPort())).endTcpSocket();
        }
        if (this.probeType.equals("exec")) {
            ((ProbeFluent.ExecNested)builder.withNewExec().withCommand(this.commandArgs)).endExec();
        }
        this.build(builder);
        return builder.build();
    }

    protected abstract void build(ProbeBuilder var1);

    private IntOrString getPort() {
        IntOrStringBuilder builder = new IntOrStringBuilder();
        if (StringUtils.isNumeric((CharSequence)this.port)) {
            builder.withIntVal(Integer.valueOf(this.port));
        } else {
            builder.withStrVal(this.port);
        }
        return builder.build();
    }

    public AbstractProbe createHttpProbe(String host, String path, String port, Map<String, String> httpHeaders) {
        this.probeType = "httpGet";
        this.path = path;
        this.port = port;
        this.host = host;
        this.httpHeaders = httpHeaders;
        return this;
    }

    public AbstractProbe createHttpProbe(String host, String path, String port) {
        return this.createHttpProbe(host, path, port, new HashMap<String, String>());
    }

    public AbstractProbe createHttpProbe(String path, String port) {
        return this.createHttpProbe(null, path, port);
    }

    public AbstractProbe createHttpProbe(String path, String port, String username, String password) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
        return this.createHttpProbe(null, path, port, headers);
    }

    public AbstractProbe createTcpProbe(String port) {
        this.probeType = "tcpSocket";
        this.port = port;
        return this;
    }

    public AbstractProbe createExecProbe(String ... commandArgs) {
        this.probeType = "exec";
        this.commandArgs = commandArgs;
        return null;
    }
}

