/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.sso.util;

import cz.xtf.http.HttpClient;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoTokenRequestor {
    private static final Logger log = LoggerFactory.getLogger(SsoTokenRequestor.class);
    private final Map<String, String> params;
    private final String ssoAuthUrl;
    private final String realm;

    public SsoTokenRequestor(String authUrl, String realm, Map<String, String> params) {
        this.ssoAuthUrl = authUrl;
        this.realm = realm;
        this.params = new HashMap<String, String>(params);
    }

    public SsoTokenRequestor(String ssoAuthUrl, String realm) {
        this(ssoAuthUrl, realm, Collections.emptyMap());
    }

    public static SsoTokenRequestor fromMasterRealmOf(String ssoAuthUrl) {
        return new SsoTokenRequestor(ssoAuthUrl, "master");
    }

    public SsoTokenRequestor username(String username) {
        this.params.put("username", username);
        return this;
    }

    public SsoTokenRequestor password(String password) {
        this.params.put("password", password);
        return this;
    }

    public SsoTokenRequestor grantType(GrantType grantType) {
        this.params.put("grant_type", grantType.toString());
        return this;
    }

    public SsoTokenRequestor clientId(String clientId) {
        this.params.put("client_id", clientId);
        return this;
    }

    public SsoTokenRequestor clientSecret(String clientSecret) {
        this.params.put("client_secret", clientSecret);
        return this;
    }

    private String buildParams() {
        return this.params.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
    }

    public TokenHolder requestNewToken() throws IOException {
        String params = this.buildParams();
        String url = this.ssoAuthUrl + "/realms/" + this.realm + "/protocol/openid-connect/token";
        log.info("Token request: {}", (Object)url);
        log.info("Request params: {} ", (Object)params);
        String response = HttpClient.post(url).data(params, ContentType.APPLICATION_FORM_URLENCODED).response();
        ModelNode tokenResponse = ModelNode.fromJSONString((String)response);
        log.debug("Token response: {}", (Object)tokenResponse);
        return new TokenHolder(tokenResponse);
    }

    public static enum GrantType {
        PASSWORD;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static class TokenHolder {
        private final ModelNode tokenResponse;

        private TokenHolder(ModelNode tokenResponse) {
            this.tokenResponse = tokenResponse;
        }

        public ModelNode getJson() {
            return this.tokenResponse;
        }

        public String getAccessToken() {
            return this.tokenResponse.get("access_token").asString();
        }
    }
}

